/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.device.ota;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.ota.DeviceGroupOtaPackage;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
@TbCoreComponent
public class DeviceOtaPackageEdgeProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceOtaPackageEdgeProcessor.class);

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        DownlinkMsg downlinkMsg = null;
        try {
            DeviceGroupOtaPackage deviceGroupOtaPackage = (DeviceGroupOtaPackage)JacksonUtil.convertValue((Object)edgeEvent.getBody(), DeviceGroupOtaPackage.class);
            if (deviceGroupOtaPackage == null) {
                return null;
            }
            UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
            downlinkMsg = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addDeviceGroupOtaPackageUpdateMsg(EdgeMsgConstructorUtils.constructDeviceGroupOtaUpdateMsg((UpdateMsgType)msgType, (DeviceGroupOtaPackage)deviceGroupOtaPackage)).build();
        }
        catch (Exception e) {
            log.error("Can't process device group ota package msg [{}]", (Object)edgeEvent, (Object)e);
        }
        return downlinkMsg;
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.DEVICE_GROUP_OTA;
    }
}

