/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.asset.profile;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.dao.service.DataValidator;
import org.thingsboard.server.gen.edge.v1.AssetProfileUpdateMsg;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

public abstract class BaseAssetProfileProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseAssetProfileProcessor.class);
    @Autowired
    private DataValidator<AssetProfile> assetProfileValidator;

    protected Pair<Boolean, Boolean> saveOrUpdateAssetProfile(TenantId tenantId, AssetProfileId assetProfileId, AssetProfileUpdateMsg assetProfileUpdateMsg) {
        boolean created = false;
        boolean assetProfileNameUpdated = false;
        assetCreationLock.lock();
        try {
            AssetProfile assetProfile = (AssetProfile)JacksonUtil.fromString((String)assetProfileUpdateMsg.getEntity(), AssetProfile.class, (boolean)true);
            if (assetProfile == null) {
                throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] assetProfileUpdateMsg {" + String.valueOf(assetProfileUpdateMsg) + "} cannot be converted to asset profile");
            }
            AssetProfile assetProfileById = this.edgeCtx.getAssetProfileService().findAssetProfileById(tenantId, assetProfileId);
            if (assetProfileById == null) {
                created = true;
                assetProfile.setId(null);
                assetProfile.setDefault(false);
            } else {
                assetProfile.setId((UUIDBased)assetProfileId);
                assetProfile.setDefault(assetProfileById.isDefault());
            }
            Object assetProfileName = assetProfile.getName();
            AssetProfile assetProfileByName = this.edgeCtx.getAssetProfileService().findAssetProfileByName(tenantId, (String)assetProfileName);
            if (assetProfileByName != null && !assetProfileByName.getId().equals((Object)assetProfileId)) {
                assetProfileName = (String)assetProfileName + "_" + StringUtils.randomAlphabetic((int)15);
                log.warn("[{}] Asset profile with name {} already exists. Renaming asset profile name to {}", new Object[]{tenantId, assetProfile.getName(), assetProfileName});
                assetProfileNameUpdated = true;
            }
            assetProfile.setName((String)assetProfileName);
            RuleChainId ruleChainId = assetProfile.getDefaultRuleChainId();
            this.setDefaultRuleChainId(tenantId, assetProfile, created ? null : assetProfileById.getDefaultRuleChainId());
            this.setDefaultEdgeRuleChainId(assetProfile, ruleChainId, assetProfileUpdateMsg);
            this.setDefaultDashboardId(tenantId, created ? null : assetProfileById.getDefaultDashboardId(), assetProfile, assetProfileUpdateMsg);
            this.assetProfileValidator.validate((BaseData)assetProfile, AssetProfile::getTenantId);
            if (created) {
                assetProfile.setId((UUIDBased)assetProfileId);
            }
            this.edgeCtx.getAssetProfileService().saveAssetProfile(assetProfile, false, true);
        }
        catch (Exception e) {
            log.error("[{}] Failed to process asset profile update msg [{}]", new Object[]{tenantId, assetProfileUpdateMsg, e});
            throw e;
        }
        finally {
            assetCreationLock.unlock();
        }
        return Pair.of((Object)created, (Object)assetProfileNameUpdated);
    }

    protected abstract void setDefaultRuleChainId(TenantId var1, AssetProfile var2, RuleChainId var3);

    protected abstract void setDefaultEdgeRuleChainId(AssetProfile var1, RuleChainId var2, AssetProfileUpdateMsg var3);

    protected abstract void setDefaultDashboardId(TenantId var1, DashboardId var2, AssetProfile var3, AssetProfileUpdateMsg var4);
}

