/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.ai;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.ai.AiModel;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.AiModelId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.gen.edge.v1.AiModelUpdateMsg;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.ai.AiModelEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.ai.AiModelProcessor;
import org.thingsboard.server.service.edge.rpc.processor.ai.BaseAiModelProcessor;

@Component
@TbCoreComponent
public class AiModelEdgeProcessor
extends BaseAiModelProcessor
implements AiModelProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AiModelEdgeProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processAiModelMsgFromEdge(TenantId tenantId, Edge edge, AiModelUpdateMsg aiModelUpdateMsg) {
        AiModelId aiModelId = new AiModelId(new UUID(aiModelUpdateMsg.getIdMSB(), aiModelUpdateMsg.getIdLSB()));
        try {
            this.edgeSynchronizationManager.getEdgeId().set(edge.getId());
            ListenableFuture listenableFuture = switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[aiModelUpdateMsg.getMsgType().ordinal()]) {
                case 1, 2 -> {
                    this.processAiModel(tenantId, aiModelId, aiModelUpdateMsg, edge);
                    yield Futures.immediateFuture(null);
                }
                case 3 -> {
                    this.deleteAiModel(tenantId, edge, aiModelId);
                    yield Futures.immediateFuture(null);
                }
                default -> this.handleUnsupportedMsgType(aiModelUpdateMsg.getMsgType());
            };
            return listenableFuture;
        }
        catch (DataValidationException e) {
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)e);
            return listenableFuture;
        }
        finally {
            this.edgeSynchronizationManager.getEdgeId().remove();
        }
    }

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        AiModelId aiModelId = new AiModelId(edgeEvent.getEntityId());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[edgeEvent.getAction().ordinal()]) {
            case 1: 
            case 2: {
                Optional aiModel = this.edgeCtx.getAiModelService().findAiModelById(edgeEvent.getTenantId(), aiModelId);
                if (!aiModel.isPresent()) break;
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                AiModelUpdateMsg aiModelUpdateMsg = EdgeMsgConstructorUtils.constructAiModelUpdatedMsg((UpdateMsgType)msgType, (AiModel)((AiModel)aiModel.get()));
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addAiModelUpdateMsg(aiModelUpdateMsg).build();
            }
            case 3: {
                AiModelUpdateMsg aiModelUpdateMsg = EdgeMsgConstructorUtils.constructAiModelDeleteMsg((AiModelId)aiModelId);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addAiModelUpdateMsg(aiModelUpdateMsg).build();
            }
        }
        return null;
    }

    private void processAiModel(TenantId tenantId, AiModelId aiModelId, AiModelUpdateMsg aiModelUpdateMsg, Edge edge) {
        Boolean aiModelNameUpdated;
        Pair resultPair = super.saveOrUpdateAiModel(tenantId, aiModelId, aiModelUpdateMsg);
        Boolean created = (Boolean)resultPair.getFirst();
        if (created.booleanValue()) {
            Optional aiModel = this.edgeCtx.getAiModelService().findAiModelById(tenantId, aiModelId);
            aiModel.ifPresent(model -> this.pushEntityEventToRuleEngine(tenantId, edge, (HasId)model, TbMsgType.ENTITY_CREATED));
        }
        if ((aiModelNameUpdated = (Boolean)resultPair.getSecond()).booleanValue()) {
            this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.AI_MODEL, EdgeEventActionType.UPDATED, (EntityId)aiModelId, null);
        }
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.AI_MODEL;
    }
}

