/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.service.edge.rpc.fetch.EdgeEventFetcher;

public class WhiteLabelingEdgeEventFetcher
implements EdgeEventFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WhiteLabelingEdgeEventFetcher.class);
    private final CustomerService customerService;

    public PageLink getPageLink(int pageSize) {
        return null;
    }

    public PageData<EdgeEvent> fetchEdgeEvents(TenantId tenantId, Edge edge, PageLink pageLink) {
        ArrayList result = new ArrayList();
        List<EdgeEventType> wlTypes = Arrays.asList(EdgeEventType.WHITE_LABELING, EdgeEventType.LOGIN_WHITE_LABELING, EdgeEventType.MAIL_TEMPLATES);
        for (EdgeEventType wlType : wlTypes) {
            List wlEdgeEvents = this.getWhiteLabelingEdgeEvents(tenantId, edge, wlType);
            result.addAll(wlEdgeEvents);
        }
        return new PageData(result, 1, (long)result.size(), false);
    }

    private List<EdgeEvent> getWhiteLabelingEdgeEvents(TenantId tenantId, Edge edge, EdgeEventType eventType) {
        try {
            EntityId ownerId = edge.getOwnerId();
            ArrayList<EdgeEvent> result = new ArrayList<EdgeEvent>();
            result.add(EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)eventType, (EdgeEventActionType)EdgeEventActionType.UPDATED, null, (JsonNode)JacksonUtil.valueToTree((Object)TenantId.SYS_TENANT_ID)));
            result.add(EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)eventType, (EdgeEventActionType)EdgeEventActionType.UPDATED, null, (JsonNode)JacksonUtil.valueToTree((Object)tenantId)));
            if (EntityType.CUSTOMER.equals((Object)ownerId.getEntityType())) {
                CustomerId customerId = new CustomerId(ownerId.getId());
                result.add(EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)eventType, (EdgeEventActionType)EdgeEventActionType.UPDATED, null, (JsonNode)JacksonUtil.valueToTree((Object)customerId)));
                Customer customer = this.customerService.findCustomerById(tenantId, customerId);
                if (customer.isSubCustomer()) {
                    this.getParentCustomerEvents(tenantId, edge.getId(), customer.getParentCustomerId(), eventType, result);
                }
            }
            return result;
        }
        catch (Exception e) {
            log.error("Can't load white labeling params", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void getParentCustomerEvents(TenantId tenantId, EdgeId edgeId, CustomerId customerId, EdgeEventType eventType, List<EdgeEvent> events) {
        events.add(EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edgeId, (EdgeEventType)eventType, (EdgeEventActionType)EdgeEventActionType.UPDATED, null, (JsonNode)JacksonUtil.valueToTree((Object)customerId)));
        Customer customer = this.customerService.findCustomerById(tenantId, customerId);
        if (customer.isSubCustomer()) {
            this.getParentCustomerEvents(tenantId, edgeId, customer.getParentCustomerId(), eventType, events);
        }
    }

    @ConstructorProperties(value={"customerService"})
    @Generated
    public WhiteLabelingEdgeEventFetcher(CustomerService customerService) {
        this.customerService = customerService;
    }
}

