/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.domain.DomainInfo;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.domain.DomainService;
import org.thingsboard.server.service.edge.rpc.fetch.BasePageableEdgeEventFetcher;

public class OAuth2EdgeEventFetcher
extends BasePageableEdgeEventFetcher<DomainInfo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth2EdgeEventFetcher.class);
    private final DomainService domainService;
    private final TenantId tenantId;
    private final CustomerId customerId;

    PageData<DomainInfo> fetchEntities(TenantId tenantId, Edge edge, PageLink pageLink) {
        return this.domainService.findDomainInfosByTenantIdAndCustomerId(this.tenantId, this.customerId, pageLink);
    }

    EdgeEvent constructEdgeEvent(TenantId tenantId, Edge edge, DomainInfo domainInfo) {
        return EdgeUtils.constructEdgeEvent((TenantId)TenantId.SYS_TENANT_ID, (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.DOMAIN, (EdgeEventActionType)EdgeEventActionType.ADDED, (EntityId)((EntityId)domainInfo.getId()), null);
    }

    @ConstructorProperties(value={"domainService", "tenantId", "customerId"})
    @Generated
    public OAuth2EdgeEventFetcher(DomainService domainService, TenantId tenantId, CustomerId customerId) {
        this.domainService = domainService;
        this.tenantId = tenantId;
        this.customerId = customerId;
    }
}

