/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.integration.IntegrationService;
import org.thingsboard.server.service.edge.rpc.fetch.BasePageableEdgeEventFetcher;

public class IntegrationsEdgeEventFetcher
extends BasePageableEdgeEventFetcher<Integration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegrationsEdgeEventFetcher.class);
    private final IntegrationService integrationService;

    PageData<Integration> fetchEntities(TenantId tenantId, Edge edge, PageLink pageLink) {
        return this.integrationService.findIntegrationsByTenantIdAndEdgeId(tenantId, edge.getId(), pageLink);
    }

    EdgeEvent constructEdgeEvent(TenantId tenantId, Edge edge, Integration integration) {
        return EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.INTEGRATION, (EdgeEventActionType)EdgeEventActionType.ADDED, (EntityId)integration.getId(), null);
    }

    @ConstructorProperties(value={"integrationService"})
    @Generated
    public IntegrationsEdgeEventFetcher(IntegrationService integrationService) {
        this.integrationService = integrationService;
    }
}

