/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.dao.edge.EdgeEventService;
import org.thingsboard.server.service.edge.rpc.fetch.EdgeEventFetcher;

public class GeneralEdgeEventFetcher
implements EdgeEventFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeneralEdgeEventFetcher.class);
    private final Long queueStartTs;
    private Long seqIdStart;
    private boolean seqIdNewCycleStarted;
    private Long maxReadRecordsCount;
    private final EdgeEventService edgeEventService;
    private final long misorderingCompensationMillis;

    public PageLink getPageLink(int pageSize) {
        return new TimePageLink(pageSize, 0, null, null, Long.valueOf(this.queueStartTs > 0L ? this.queueStartTs - this.misorderingCompensationMillis : 0L), Long.valueOf(System.currentTimeMillis()));
    }

    public PageData<EdgeEvent> fetchEdgeEvents(TenantId tenantId, Edge edge, PageLink pageLink) {
        try {
            log.trace("[{}] Finding general edge events [{}], seqIdStart = {}, pageLink = {}", new Object[]{tenantId, edge.getId(), this.seqIdStart, pageLink});
            PageData edgeEvents = this.edgeEventService.findEdgeEvents(tenantId, edge.getId(), this.seqIdStart, null, (TimePageLink)pageLink);
            if (!edgeEvents.getData().isEmpty()) {
                return edgeEvents;
            }
            if (this.seqIdStart > this.maxReadRecordsCount && (edgeEvents = this.edgeEventService.findEdgeEvents(tenantId, edge.getId(), Long.valueOf(0L), Long.valueOf(Math.max(this.maxReadRecordsCount, this.seqIdStart - this.maxReadRecordsCount)), (TimePageLink)pageLink)).getData().stream().anyMatch(ee -> ee.getSeqId() < this.seqIdStart)) {
                log.info("[{}] seqId column of edge_event table started new cycle [{}]", (Object)tenantId, (Object)edge.getId());
                this.seqIdNewCycleStarted = true;
                this.seqIdStart = 0L;
                return edgeEvents;
            }
            log.info("[{}] Unexpected edge notification message received. No new events found, and the seqId column of the edge_event table has not started a new cycle [{}].", (Object)tenantId, (Object)edge.getId());
            return new PageData();
        }
        catch (Exception e) {
            log.error("[{}] Failed to find edge events [{}]", new Object[]{tenantId, edge.getId(), e});
            return new PageData();
        }
    }

    @ConstructorProperties(value={"queueStartTs", "seqIdStart", "seqIdNewCycleStarted", "maxReadRecordsCount", "edgeEventService", "misorderingCompensationMillis"})
    @Generated
    public GeneralEdgeEventFetcher(Long queueStartTs, Long seqIdStart, boolean seqIdNewCycleStarted, Long maxReadRecordsCount, EdgeEventService edgeEventService, long misorderingCompensationMillis) {
        this.queueStartTs = queueStartTs;
        this.seqIdStart = seqIdStart;
        this.seqIdNewCycleStarted = seqIdNewCycleStarted;
        this.maxReadRecordsCount = maxReadRecordsCount;
        this.edgeEventService = edgeEventService;
        this.misorderingCompensationMillis = misorderingCompensationMillis;
    }

    @Generated
    public boolean isSeqIdNewCycleStarted() {
        return this.seqIdNewCycleStarted;
    }
}

