/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.encryptionkey.EncryptionKey;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.encryptionkey.EncryptionService;
import org.thingsboard.server.service.edge.rpc.fetch.BasePageableEdgeEventFetcher;

public class EncryptionKeyEdgeEventFetcher
extends BasePageableEdgeEventFetcher<EncryptionKey> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptionKeyEdgeEventFetcher.class);
    private final EncryptionService encryptionService;

    PageData<EncryptionKey> fetchEntities(TenantId tenantId, Edge edge, PageLink pageLink) {
        EncryptionKey key = this.encryptionService.findByTenantId(tenantId);
        return new PageData(List.of(key), 1, 1L, false);
    }

    EdgeEvent constructEdgeEvent(TenantId tenantId, Edge edge, EncryptionKey entity) {
        return EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.ENCRYPTION_KEY, (EdgeEventActionType)EdgeEventActionType.ADDED, null, null);
    }

    @ConstructorProperties(value={"encryptionService"})
    @Generated
    public EncryptionKeyEdgeEventFetcher(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }
}

