/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.dao.ota.DeviceGroupOtaPackageService;
import org.thingsboard.server.service.edge.rpc.fetch.EdgeEventFetcher;

public class DeviceGroupOtaPackageEdgeEventFetcher
implements EdgeEventFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceGroupOtaPackageEdgeEventFetcher.class);
    private final DeviceGroupOtaPackageService deviceGroupOtaPackageService;
    private final EntityGroupService entityGroupService;

    public PageLink getPageLink(int pageSize) {
        return new PageLink(pageSize);
    }

    public PageData<EdgeEvent> fetchEdgeEvents(TenantId tenantId, Edge edge, PageLink pageLink) throws Exception {
        PageData pageData = this.entityGroupService.findEdgeEntityGroupsByType(tenantId, edge.getId(), EntityType.DEVICE, pageLink);
        ArrayList result = new ArrayList();
        if (!pageData.getData().isEmpty()) {
            for (EntityGroup entityGroup : pageData.getData()) {
                this.deviceGroupOtaPackageService.findDeviceGroupOtaPackageByGroupId(entityGroup.getId()).forEach(otaPackage -> result.add(EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.DEVICE_GROUP_OTA, (EdgeEventActionType)EdgeEventActionType.UPDATED, (EntityId)otaPackage.getGroupId(), (JsonNode)JacksonUtil.valueToTree((Object)otaPackage))));
            }
        }
        return new PageData(result, 1, (long)result.size(), false);
    }

    @ConstructorProperties(value={"deviceGroupOtaPackageService", "entityGroupService"})
    @Generated
    public DeviceGroupOtaPackageEdgeEventFetcher(DeviceGroupOtaPackageService deviceGroupOtaPackageService, EntityGroupService entityGroupService) {
        this.deviceGroupOtaPackageService = deviceGroupOtaPackageService;
        this.entityGroupService = entityGroupService;
    }
}

