/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.asset.AssetProfileService;
import org.thingsboard.server.dao.device.DeviceProfileService;
import org.thingsboard.server.service.edge.rpc.fetch.EdgeEventFetcher;

public class DefaultProfilesEdgeEventFetcher
implements EdgeEventFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultProfilesEdgeEventFetcher.class);
    private final DeviceProfileService deviceProfileService;
    private final AssetProfileService assetProfileService;

    public PageLink getPageLink(int pageSize) {
        return null;
    }

    public PageData<EdgeEvent> fetchEdgeEvents(TenantId tenantId, Edge edge, PageLink pageLink) {
        ArrayList<EdgeEvent> result = new ArrayList<EdgeEvent>();
        DeviceProfile deviceProfile = this.deviceProfileService.findDefaultDeviceProfile(tenantId);
        result.add(EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.DEVICE_PROFILE, (EdgeEventActionType)EdgeEventActionType.ADDED, (EntityId)deviceProfile.getId(), null));
        AssetProfile assetProfile = this.assetProfileService.findDefaultAssetProfile(tenantId);
        result.add(EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.ASSET_PROFILE, (EdgeEventActionType)EdgeEventActionType.ADDED, (EntityId)assetProfile.getId(), null));
        return new PageData(result, 1, (long)result.size(), false);
    }

    @ConstructorProperties(value={"deviceProfileService", "assetProfileService"})
    @Generated
    public DefaultProfilesEdgeEventFetcher(DeviceProfileService deviceProfileService, AssetProfileService assetProfileService) {
        this.deviceProfileService = deviceProfileService;
        this.assetProfileService = assetProfileService;
    }
}

