/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.translation.CustomTranslation;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.translation.CustomTranslationService;
import org.thingsboard.server.service.edge.rpc.fetch.EdgeEventFetcher;

public class CustomTranslationEdgeEventFetcher
implements EdgeEventFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomTranslationEdgeEventFetcher.class);
    private final CustomerService customerService;
    private final CustomTranslationService customTranslationService;

    public PageLink getPageLink(int pageSize) {
        return null;
    }

    public PageData<EdgeEvent> fetchEdgeEvents(TenantId tenantId, Edge edge, PageLink pageLink) throws Exception {
        ArrayList result = new ArrayList();
        EdgeId edgeId = edge.getId();
        this.processTenantLocales(TenantId.SYS_TENANT_ID, edgeId, result);
        this.processTenantLocales(tenantId, edgeId, result);
        if (EntityType.CUSTOMER.equals((Object)edge.getOwnerId().getEntityType())) {
            this.processCustomerLocales(tenantId, edge.getCustomerId(), edgeId, result);
        }
        return new PageData(result, 1, (long)result.size(), false);
    }

    private void processTenantLocales(TenantId tenantId, EdgeId edgeId, List<EdgeEvent> result) {
        Set locales = this.customTranslationService.getCurrentCustomizedLocales(tenantId, null);
        for (String locale : locales) {
            this.addLocaleEvent(tenantId, null, locale, edgeId, result);
        }
    }

    private void processCustomerLocales(TenantId tenantId, CustomerId customerId, EdgeId edgeId, List<EdgeEvent> result) {
        Set customerLocales = this.customTranslationService.getCurrentCustomizedLocales(tenantId, customerId);
        for (String locale : customerLocales) {
            this.addLocaleEvent(tenantId, customerId, locale, edgeId, result);
            Customer customer = this.customerService.findCustomerById(tenantId, customerId);
            if (!customer.isSubCustomer()) continue;
            this.getParentCustomerEvents(tenantId, customer.getParentCustomerId(), locale, edgeId, result);
        }
    }

    private void getParentCustomerEvents(TenantId tenantId, CustomerId customerId, String locale, EdgeId edgeId, List<EdgeEvent> result) {
        this.addLocaleEvent(tenantId, customerId, locale, edgeId, result);
        Customer customer = this.customerService.findCustomerById(tenantId, customerId);
        if (customer.isSubCustomer()) {
            this.getParentCustomerEvents(tenantId, customer.getParentCustomerId(), locale, edgeId, result);
        }
    }

    private void addLocaleEvent(TenantId tenantId, CustomerId customerId, String locale, EdgeId edgeId, List<EdgeEvent> events) {
        JsonNode value = this.customTranslationService.getCurrentCustomTranslation(tenantId, customerId, locale);
        CustomTranslation customTranslation = CustomTranslation.builder().tenantId(tenantId).customerId(customerId).localeCode(locale).value(value).build();
        events.add(EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edgeId, (EdgeEventType)EdgeEventType.CUSTOM_TRANSLATION, (EdgeEventActionType)EdgeEventActionType.UPDATED, null, (JsonNode)JacksonUtil.valueToTree((Object)customTranslation)));
    }

    @ConstructorProperties(value={"customerService", "customTranslationService"})
    @Generated
    public CustomTranslationEdgeEventFetcher(CustomerService customerService, CustomTranslationService customTranslationService) {
        this.customerService = customerService;
        this.customTranslationService = customTranslationService;
    }
}

