/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.AdminSettings;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.settings.AdminSettingsService;
import org.thingsboard.server.service.edge.rpc.fetch.EdgeEventFetcher;

public class AdminSettingsEdgeEventFetcher
implements EdgeEventFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminSettingsEdgeEventFetcher.class);
    private final AdminSettingsService adminSettingsService;

    public PageLink getPageLink(int pageSize) {
        return null;
    }

    public PageData<EdgeEvent> fetchEdgeEvents(TenantId tenantId, Edge edge, PageLink pageLink) throws Exception {
        List result = this.fetchAdminSettingsForKeys(tenantId, edge.getId(), List.of("general", "mail", "connectivity", "jwt", "customMenu"));
        return new PageData(result, 1, (long)result.size(), false);
    }

    private List<EdgeEvent> fetchAdminSettingsForKeys(TenantId tenantId, EdgeId edgeId, List<String> keys) {
        ArrayList<EdgeEvent> result = new ArrayList<EdgeEvent>();
        for (String key : keys) {
            this.createAdminSettingsEvent(TenantId.SYS_TENANT_ID, key, edgeId).ifPresent(result::add);
            this.createAdminSettingsEvent(tenantId, key, edgeId).ifPresent(result::add);
        }
        return result;
    }

    private Optional<EdgeEvent> createAdminSettingsEvent(TenantId tenantId, String key, EdgeId edgeId) {
        AdminSettings settings = this.adminSettingsService.findAdminSettingsByTenantIdAndKey(tenantId, key);
        if (settings != null) {
            return Optional.of(EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edgeId, (EdgeEventType)EdgeEventType.ADMIN_SETTINGS, (EdgeEventActionType)EdgeEventActionType.UPDATED, null, (JsonNode)JacksonUtil.valueToTree((Object)settings)));
        }
        return Optional.empty();
    }

    @ConstructorProperties(value={"adminSettingsService"})
    @Generated
    public AdminSettingsEdgeEventFetcher(AdminSettingsService adminSettingsService) {
        this.adminSettingsService = adminSettingsService;
    }
}

