/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.gen.edge.v1.ResponseMsg;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.common.consumer.QueueConsumerManager;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.kafka.KafkaAdmin;
import org.thingsboard.server.queue.provider.TbCoreQueueFactory;
import org.thingsboard.server.service.edge.EdgeContextComponent;
import org.thingsboard.server.service.edge.rpc.EdgeGrpcSession;

public class KafkaEdgeGrpcSession
extends EdgeGrpcSession {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaEdgeGrpcSession.class);
    private final TopicService topicService;
    private final TbCoreQueueFactory tbCoreQueueFactory;
    private final KafkaAdmin kafkaAdmin;
    private volatile boolean isHighPriorityProcessing;
    private QueueConsumerManager<TbProtoQueueMsg<TransportProtos.ToEdgeEventNotificationMsg>> consumer;
    private ExecutorService consumerExecutor;

    public KafkaEdgeGrpcSession(EdgeContextComponent ctx, TopicService topicService, TbCoreQueueFactory tbCoreQueueFactory, KafkaAdmin kafkaAdmin, StreamObserver<ResponseMsg> outputStream, BiConsumer<EdgeId, EdgeGrpcSession> sessionOpenListener, BiConsumer<Edge, UUID> sessionCloseListener, ScheduledExecutorService sendDownlinkExecutorService, int maxInboundMessageSize, int maxHighPriorityQueueSizePerSession) {
        super(ctx, outputStream, sessionOpenListener, sessionCloseListener, sendDownlinkExecutorService, maxInboundMessageSize, maxHighPriorityQueueSizePerSession);
        this.topicService = topicService;
        this.tbCoreQueueFactory = tbCoreQueueFactory;
        this.kafkaAdmin = kafkaAdmin;
    }

    private void processMsgs(List<TbProtoQueueMsg<TransportProtos.ToEdgeEventNotificationMsg>> msgs, TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToEdgeEventNotificationMsg>> consumer) throws InterruptedException {
        boolean isProcessed = false;
        do {
            log.trace("[{}][{}] Trying to process edge events", (Object)this.tenantId, (Object)this.edge.getId());
            if (this.isConnected() && !this.isSyncInProgress() && !this.isHighPriorityProcessing) {
                isProcessed = this.tryProcessMsgs(msgs, consumer);
            } else {
                log.debug("[{}][{}] edge not connected, edge sync is not completed or high priority processing in progress, connected = {}, sync in progress = {}, high priority in progress = {}. Skipping iteration", new Object[]{this.tenantId, this.edge.getId(), this.isConnected(), this.isSyncInProgress(), this.isHighPriorityProcessing});
            }
            if (isProcessed) continue;
            this.sleep();
        } while (!isProcessed);
    }

    private boolean tryProcessMsgs(List<TbProtoQueueMsg<TransportProtos.ToEdgeEventNotificationMsg>> msgs, TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToEdgeEventNotificationMsg>> consumer) {
        List<EdgeEvent> edgeEvents = msgs.stream().map(msg -> ProtoUtils.fromProto((TransportProtos.EdgeEventMsgProto)((TransportProtos.ToEdgeEventNotificationMsg)msg.getValue()).getEdgeEventMsg())).toList();
        List downlinkMsgsPack = this.convertToDownlinkMsgsPack(edgeEvents);
        try {
            if (((Boolean)this.sendDownlinkMsgsPack(downlinkMsgsPack).get()).booleanValue()) {
                log.debug("[{}][{}] Send downlink messages task was interrupted", (Object)this.tenantId, (Object)this.edge.getId());
                return false;
            }
        }
        catch (Exception e) {
            log.error("[{}][{}] Failed to process downlink messages", new Object[]{this.tenantId, this.edge.getId(), e});
            return false;
        }
        consumer.commit();
        return true;
    }

    private void sleep() {
        try {
            Thread.sleep(this.ctx.getEdgeEventStorageSettings().getNoRecordsSleepInterval());
        }
        catch (InterruptedException interruptedException) {
            log.trace("[{}][{}] Interrupted while waiting to retry edge events processing", new Object[]{this.tenantId, this.edge.getId(), interruptedException});
        }
    }

    public ListenableFuture<Boolean> migrateEdgeEvents() throws Exception {
        return super.processEdgeEvents();
    }

    public ListenableFuture<Boolean> processEdgeEvents() {
        if (!this.isConnected() || this.isSyncInProgress() || this.isHighPriorityProcessing) {
            log.warn("[{}][{}] Session is not ready (connected={}, syncInProgress={}, highPriority={}), skip starting edge event consumer", new Object[]{this.tenantId, this.edge != null ? this.edge.getId() : null, this.isConnected(), this.isSyncInProgress(), this.isHighPriorityProcessing});
            return Futures.immediateFuture((Object)Boolean.FALSE);
        }
        if (this.consumer == null || this.consumer.getConsumer() != null && this.consumer.getConsumer().isStopped()) {
            try {
                if (this.consumerExecutor != null && !this.consumerExecutor.isShutdown()) {
                    try {
                        this.consumerExecutor.shutdown();
                        this.awaitConsumerTermination();
                    }
                    catch (Exception e) {
                        log.warn("[{}][{}] Failed to shutdown previous consumer executor", new Object[]{this.tenantId, this.edge.getId(), e});
                    }
                }
                this.consumerExecutor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"edge-event-consumer"));
                this.consumer = QueueConsumerManager.builder().name("TB Edge events [" + String.valueOf(this.edge.getId()) + "]").msgPackProcessor((arg_0, arg_1) -> this.processMsgs(arg_0, arg_1)).pollInterval(this.ctx.getEdgeEventStorageSettings().getNoRecordsSleepInterval()).consumerCreator(() -> this.tbCoreQueueFactory.createEdgeEventMsgConsumer(this.tenantId, this.edge.getId())).consumerExecutor(this.consumerExecutor).threadPrefix("edge-events-" + String.valueOf(this.edge.getId())).build();
                this.consumer.subscribe();
                this.consumer.launch();
            }
            catch (Exception e) {
                this.destroy();
                log.warn("[{}][{}] Failed to start edge event consumer", new Object[]{this.sessionId, this.edge.getId(), e});
            }
        }
        return Futures.immediateFuture((Object)Boolean.FALSE);
    }

    public void processHighPriorityEvents() {
        this.isHighPriorityProcessing = true;
        super.processHighPriorityEvents();
        this.isHighPriorityProcessing = false;
    }

    public boolean destroy() {
        try {
            if (this.consumer != null) {
                log.info("[{}][{}] Stopping edge event consumer...", (Object)this.tenantId, this.edge != null ? this.edge.getId() : null);
                this.consumer.stop();
            }
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to stop edge event consumer", new Object[]{this.tenantId, this.edge.getId(), e});
            return false;
        }
        this.consumer = null;
        try {
            if (this.consumerExecutor != null && !this.consumerExecutor.isShutdown()) {
                this.consumerExecutor.shutdown();
                this.awaitConsumerTermination();
            }
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to shutdown edge event consumer executor", new Object[]{this.tenantId, this.edge.getId(), e});
            return false;
        }
        return true;
    }

    private void awaitConsumerTermination() {
        try {
            this.consumerExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            log.warn("[{}][{}] Interrupted while awaiting consumer executor termination", (Object)this.tenantId, (Object)this.edge.getId());
        }
    }

    public void cleanUp() {
        String topic = this.topicService.buildEdgeEventNotificationsTopicPartitionInfo(this.tenantId, this.edge.getId()).getTopic();
        this.kafkaAdmin.deleteTopic(topic);
        this.kafkaAdmin.deleteConsumerGroup(topic);
    }

    @Generated
    public QueueConsumerManager<TbProtoQueueMsg<TransportProtos.ToEdgeEventNotificationMsg>> getConsumer() {
        return this.consumer;
    }
}

