/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.rpc.CustomersHierarchyEdgeService;
import org.thingsboard.server.service.edge.rpc.DefaultCustomersHierarchyEdgeService;

@Service
@TbCoreComponent
public class DefaultCustomersHierarchyEdgeService
implements CustomersHierarchyEdgeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultCustomersHierarchyEdgeService.class);
    private static final CustomerId NULL_CUSTOMER_ID = new CustomerId(CustomerId.NULL_UUID);
    private final CustomerHierarchyNode root = new CustomerHierarchyNode(NULL_CUSTOMER_ID, new ArrayList(), new ArrayList());
    @Autowired
    private CustomerService customerService;
    @Autowired
    private EdgeService edgeService;
    @Autowired
    private TenantService tenantService;
    private ScheduledExecutorService scheduledExecutor;

    @PostConstruct
    private void init() {
        this.scheduledExecutor = ThingsBoardExecutors.newSingleThreadScheduledExecutor((String)"edge-customers-hierarchy");
    }

    @AfterStartUp(order=11)
    public void onApplicationEvent(ApplicationReadyEvent ignored) {
        this.scheduledExecutor.schedule(() -> this.fetchCustomersHierarchy(), 1L, TimeUnit.SECONDS);
    }

    private void fetchCustomersHierarchy() {
        PageData tenantsIds;
        PageLink pageLink = new PageLink(100, 0);
        do {
            tenantsIds = this.tenantService.findTenantsIds(pageLink);
            for (TenantId tenantId : tenantsIds.getData()) {
                PageData edgesByTenantId;
                PageLink pageLink1 = new PageLink(100, 0);
                do {
                    edgesByTenantId = this.edgeService.findEdgesByTenantId(tenantId, pageLink1);
                    for (Edge edge : edgesByTenantId.getData()) {
                        List customersHierarchyIds = this.getCustomersHierarchyIds(edge.getTenantId(), edge.getCustomerId());
                        this.addEdgeToCustomersHierarchy(customersHierarchyIds, edge.getId(), this.root);
                    }
                    pageLink1 = pageLink1.nextPageLink();
                } while (edgesByTenantId.hasNext());
            }
            pageLink = pageLink.nextPageLink();
        } while (tenantsIds.hasNext());
    }

    @PreDestroy
    public void shutdownExecutor() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdownNow();
        }
    }

    private List<CustomerId> getCustomersHierarchyIds(TenantId tenantId, CustomerId customerId) {
        List customersHierarchy = this.getCustomersHierarchy(tenantId, customerId);
        return customersHierarchy.stream().map(Customer::getId).collect(Collectors.toList());
    }

    public List<Customer> getCustomersHierarchy(TenantId tenantId, CustomerId customerId) {
        Customer customerById;
        ArrayList<Customer> result = new ArrayList<Customer>();
        if (customerId != null && !customerId.isNullUid() && (customerById = this.customerService.findCustomerById(tenantId, customerId)) != null) {
            result.add(customerById);
            CustomerId parentId = customerById.getParentCustomerId();
            if (parentId != null) {
                result.addAll(this.getCustomersHierarchy(tenantId, parentId));
            }
        }
        Collections.reverse(result);
        return result;
    }

    private void addEdgeToCustomersHierarchy(List<CustomerId> customerIds, EdgeId edgeId, CustomerHierarchyNode node) {
        if (customerIds.isEmpty()) {
            node.getEdgeIds().add(edgeId);
            return;
        }
        CustomerId customerId = customerIds.remove(0);
        CustomerHierarchyNode childNode = null;
        for (CustomerHierarchyNode tmpNode : node.getChildren()) {
            if (!tmpNode.getCustomerId().equals((Object)customerId)) continue;
            childNode = tmpNode;
            break;
        }
        if (childNode == null) {
            childNode = new CustomerHierarchyNode(customerId, new ArrayList(), new ArrayList());
            node.getChildren().add(childNode);
        }
        this.addEdgeToCustomersHierarchy(customerIds, edgeId, childNode);
    }

    public List<EdgeId> findAllEdgesInHierarchyByCustomerId(TenantId tenantId, CustomerId customerId) {
        log.trace("Executing findEdgesByCustomerId [{}]", (Object)customerId);
        return this.findAllEdgesInHierarchyByCustomerId(customerId, this.root, false);
    }

    private List<EdgeId> findAllEdgesInHierarchyByCustomerId(CustomerId customerId, CustomerHierarchyNode node, boolean include) {
        ArrayList<EdgeId> result = new ArrayList<EdgeId>();
        if (node.getCustomerId().equals((Object)customerId)) {
            log.trace("Found customer id in hierarchy [{}]", (Object)node);
            include = true;
        }
        if (include) {
            result.addAll(node.getEdgeIds());
        }
        for (CustomerHierarchyNode child : node.getChildren()) {
            log.trace("Processing hierarchy node [{}]", (Object)node);
            result.addAll(this.findAllEdgesInHierarchyByCustomerId(customerId, child, include));
        }
        return result;
    }

    public void processEdgeChangeOwner(TenantId tenantId, EdgeId edgeId, EntityId previousOwnerId) {
        Edge edge;
        CustomerId previousCustomerId;
        CustomerHierarchyNode node;
        log.trace("Executing processEdgeChangeOwner [{}]", (Object)edgeId);
        if (previousOwnerId == null || EntityType.TENANT.equals((Object)previousOwnerId.getEntityType())) {
            previousOwnerId = NULL_CUSTOMER_ID;
        }
        if ((node = this.findNodeByCustomerId(previousCustomerId = new CustomerId(previousOwnerId.getId()), this.root)) != null) {
            node.getEdgeIds().remove(edgeId);
        }
        if ((edge = this.edgeService.findEdgeById(tenantId, edgeId)) != null) {
            List customersHierarchyIds = this.getCustomersHierarchyIds(edge.getTenantId(), edge.getCustomerId());
            this.addEdgeToCustomersHierarchy(customersHierarchyIds, edge.getId(), this.root);
        }
    }

    private CustomerHierarchyNode findNodeByCustomerId(CustomerId customerId, CustomerHierarchyNode node) {
        if (node.getCustomerId().equals((Object)customerId)) {
            log.trace("Found customer id in hierarchy [{}]", (Object)node);
            return node;
        }
        for (CustomerHierarchyNode child : node.getChildren()) {
            log.trace("Processing hierarchy node [{}]", (Object)node);
            CustomerHierarchyNode result = this.findNodeByCustomerId(customerId, child);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

