/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.annotation.PostConstruct;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import lombok.Generated;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeLicenseService;

@Service
@TbCoreComponent
public class DefaultEdgeLicenseService
implements EdgeLicenseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEdgeLicenseService.class);
    private static final int CONNECT_TIMEOUT = 30000;
    private static final int READ_TIMEOUT = 30000;
    private RestTemplate restTemplate;
    private static final String EDGE_LICENSE_SERVER_ENDPOINT = "https://license.thingsboard.io";
    @Value(value="${edges.enabled:false}")
    private boolean edgesEnabled;

    @PostConstruct
    public void init() {
        if (this.edgesEnabled) {
            this.restTemplate = this.initRestTemplate();
        }
    }

    public ResponseEntity<JsonNode> checkInstance(JsonNode request) {
        log.trace("checkInstance [{}]", (Object)request);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        ResponseEntity response = this.restTemplate.postForEntity("https://license.thingsboard.io/api/license/checkInstance", (Object)new HttpEntity((Object)request, (MultiValueMap)headers), JsonNode.class, new Object[0]);
        log.trace("checkInstance response: {}", (Object)response);
        return new ResponseEntity((Object)((JsonNode)response.getBody()), response.getStatusCode());
    }

    public ResponseEntity<JsonNode> activateInstance(String edgeLicenseSecret, String releaseDate) {
        log.trace("activateInstance [{}][{}]", (Object)edgeLicenseSecret, (Object)releaseDate);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("licenseSecret", edgeLicenseSecret);
        params.put("releaseDate", releaseDate);
        ResponseEntity response = this.restTemplate.postForEntity("https://license.thingsboard.io/api/license/activateInstance?licenseSecret={licenseSecret}&releaseDate={releaseDate}", null, JsonNode.class, params);
        log.trace("activateInstance response: {}", (Object)response);
        return new ResponseEntity((Object)((JsonNode)response.getBody()), response.getStatusCode());
    }

    private RestTemplate initRestTemplate() {
        boolean proxyEnabled;
        boolean jdkHttpClientEnabled = StringUtils.isNotEmpty((String)System.getProperty("tb.proxy.jdk")) && System.getProperty("tb.proxy.jdk").equalsIgnoreCase("true");
        boolean systemProxyEnabled = StringUtils.isNotEmpty((String)System.getProperty("tb.proxy.system")) && System.getProperty("tb.proxy.system").equalsIgnoreCase("true");
        boolean bl = proxyEnabled = StringUtils.isNotEmpty((String)System.getProperty("tb.proxy.host")) && StringUtils.isNotEmpty((String)System.getProperty("tb.proxy.port"));
        if (jdkHttpClientEnabled) {
            log.warn("Going to use plain JDK Http Client!");
            SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
            if (proxyEnabled) {
                log.warn("Going to use Proxy Server: [{}:{}]", (Object)System.getProperty("tb.proxy.host"), (Object)System.getProperty("tb.proxy.port"));
                factory.setProxy(new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(System.getProperty("tb.proxy.host"), Integer.parseInt(System.getProperty("tb.proxy.port")))));
            }
            factory.setConnectTimeout(30000);
            factory.setReadTimeout(30000);
            return new RestTemplate((ClientHttpRequestFactory)factory);
        }
        if (systemProxyEnabled) {
            log.warn("Going to use System Proxy Server!");
            CloseableHttpClient httpClient = HttpClients.createSystem();
            HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
            factory.setHttpClient((HttpClient)httpClient);
            factory.setConnectTimeout(30000);
            factory.setConnectionRequestTimeout(30000);
            return new RestTemplate((ClientHttpRequestFactory)factory);
        }
        if (proxyEnabled) {
            log.warn("Going to use Proxy Server: [{}:{}]", (Object)System.getProperty("tb.proxy.host"), (Object)System.getProperty("tb.proxy.port"));
            CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager(this.createConnectionManager()).setProxy(new HttpHost("https", System.getProperty("tb.proxy.host"), Integer.parseInt(System.getProperty("tb.proxy.port")))).build();
            HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
            factory.setHttpClient((HttpClient)httpClient);
            factory.setConnectTimeout(30000);
            factory.setConnectionRequestTimeout(30000);
            return new RestTemplate((ClientHttpRequestFactory)factory);
        }
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager(this.createConnectionManager()).build();
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        factory.setHttpClient((HttpClient)httpClient);
        factory.setConnectTimeout(30000);
        factory.setConnectionRequestTimeout(30000);
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    private HttpClientConnectionManager createConnectionManager() {
        SSLConnectionSocketFactory socketFactory = SSLConnectionSocketFactory.getSocketFactory();
        return PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).build();
    }
}

