/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.converter;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.LibraryConvertersInfo;
import org.thingsboard.server.common.data.converter.ConverterType;
import org.thingsboard.server.common.data.integration.IntegrationType;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.converter.ConverterLibraryService;
import org.thingsboard.server.service.converter.Model;
import org.thingsboard.server.service.converter.Vendor;
import org.thingsboard.server.service.sync.GitSyncService;
import org.thingsboard.server.service.sync.vc.GitRepository;

@TbCoreComponent
@Service
public class DefaultConverterLibraryService
implements ConverterLibraryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultConverterLibraryService.class);
    private final GitSyncService gitSyncService;
    @Value(value="${integrations.converters.library.enabled:true}")
    private boolean enabled;
    @Value(value="${integrations.converters.library.url:https://github.com/thingsboard/data-converters.git}")
    private String repoUrl;
    @Value(value="${integrations.converters.library.branch}")
    private String branch;
    @Value(value="${integrations.converters.library.fetch_frequency:24}")
    private int fetchFrequencyHours;
    private Map<String, LibraryConvertersInfo> convertersInfo;
    private static final String REPO_KEY = "data-converters-library";

    @AfterStartUp(order=11)
    public void init() throws Exception {
        if (!this.enabled) {
            return;
        }
        this.gitSyncService.registerSync(REPO_KEY, this.repoUrl, this.branch, TimeUnit.HOURS.toMillis(this.fetchFrequencyHours), () -> this.updateConvertersInfo());
    }

    public List<Vendor> getVendors(IntegrationType integrationType, String converterType) {
        log.trace("Executing getVendors [{}]", (Object)integrationType);
        return this.listFiles("VENDORS", 1, true).stream().filter(vendorDir -> {
            Set integrationTypes = this.listFiles(vendorDir.path(), 3, true).stream().filter(integrationDir -> this.hasConverter(integrationDir, integrationType, converterType)).map(GitRepository.RepoFile::name).collect(Collectors.toSet());
            return integrationTypes.contains(integrationType.getDirectory());
        }).map(vendorDir -> {
            String logoFile = this.findFile(vendorDir.path(), 2, "logo");
            String logo = "data:image/svg+xml;base64," + Base64.getEncoder().encodeToString(this.gitSyncService.getFileContent(REPO_KEY, logoFile));
            return new Vendor(vendorDir.name(), logo);
        }).toList();
    }

    public List<Model> getVendorModels(IntegrationType integrationType, String converterType, String vendorName) {
        log.trace("Executing getVendorModels [{}][{}][{}]", new Object[]{integrationType, converterType, vendorName});
        return this.listFiles("VENDORS/" + vendorName, 3, true).stream().filter(integrationDir -> this.hasConverter(integrationDir, integrationType, converterType)).map(integrationDir -> Path.of(integrationDir.path(), new String[0]).getParent()).map(modelPath -> {
            String name = modelPath.getFileName().toString();
            JsonNode modelInfo = JacksonUtil.toJsonNode((String)this.getFileContent(String.valueOf(modelPath) + "/info.json"));
            String photoFile = this.findFile(modelPath.toString(), 3, "photo");
            String photo = "data:image/png;base64," + Base64.getEncoder().encodeToString(this.gitSyncService.getFileContent(REPO_KEY, photoFile));
            return new Model(name, modelInfo, photo);
        }).toList();
    }

    private boolean hasConverter(GitRepository.RepoFile integrationDir, IntegrationType integrationType, String converterType) {
        if (!integrationDir.name().equals(integrationType.getDirectory())) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)converterType)) {
            return true;
        }
        return this.listFiles(integrationDir.path(), 4, true).stream().map(GitRepository.RepoFile::name).anyMatch(name -> name.equals(converterType));
    }

    public String getConverter(IntegrationType integrationType, String converterType, String vendorName, String model) {
        log.trace("Executing getConverter [{}][{}][{}][{}]", new Object[]{integrationType, converterType, vendorName, model});
        return this.getFileContent(this.getConverterDir(integrationType, converterType, vendorName, model) + "/converter.json");
    }

    public String getConverterMetadata(IntegrationType integrationType, String converterType, String vendorName, String model) {
        log.trace("Executing getConverterMetadata [{}][{}][{}][{}]", new Object[]{integrationType, converterType, vendorName, model});
        return this.getFileContent(this.getConverterDir(integrationType, converterType, vendorName, model) + "/metadata.json");
    }

    public String getPayload(IntegrationType integrationType, String converterType, String vendorName, String model) {
        log.trace("Executing getPayload [{}][{}][{}][{}]", new Object[]{integrationType, converterType, vendorName, model});
        List<GitRepository.RepoFile> payloadFiles = this.listFiles(this.getConverterDir(integrationType, converterType, vendorName, model), -1, false).stream().filter(file -> file.name().startsWith("payload")).sorted(Comparator.comparing(GitRepository.RepoFile::name)).toList();
        if (payloadFiles.isEmpty()) {
            return "{}";
        }
        GitRepository.RepoFile payloadFile = null;
        for (GitRepository.RepoFile file2 : payloadFiles) {
            if (!file2.name().endsWith("json")) continue;
            payloadFile = file2;
            break;
        }
        if (payloadFile == null) {
            payloadFile = payloadFiles.get(0);
        }
        return this.getFileContent(payloadFile.path());
    }

    public Map<String, LibraryConvertersInfo> getConvertersInfo() {
        return this.convertersInfo != null ? this.convertersInfo : Collections.emptyMap();
    }

    private String findFile(String dir, int depth, String prefix) {
        return this.listFiles(dir, depth, false).stream().filter(file -> file.name().startsWith(prefix)).findFirst().map(GitRepository.RepoFile::path).orElse(null);
    }

    private List<GitRepository.RepoFile> listFiles(String path, int depth, boolean isDirectory) {
        if (!this.enabled) {
            throw new IllegalArgumentException("Data converters library is disabled");
        }
        return this.gitSyncService.listFiles(REPO_KEY, path, depth, isDirectory ? GitRepository.FileType.DIRECTORY : GitRepository.FileType.FILE);
    }

    private String getFileContent(String path) {
        if (!this.enabled) {
            throw new IllegalArgumentException("Data converters library is disabled");
        }
        try {
            return new String(this.gitSyncService.getFileContent(REPO_KEY, path), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            log.warn("Failed to get file content for path {}: {}", (Object)path, (Object)e.getMessage());
            return "{}";
        }
    }

    private String getConverterDir(IntegrationType integrationType, String converterType, String vendorName, String model) {
        return Path.of("VENDORS", vendorName, model, integrationType.getDirectory(), converterType).toString();
    }

    private void updateConvertersInfo() {
        log.debug("Updating converters info");
        this.convertersInfo = this.listFiles("VENDORS", 4, true).stream().collect(Collectors.groupingBy(repoFile -> Path.of(repoFile.path(), new String[0]).getParent().getFileName().toString(), Collectors.collectingAndThen(Collectors.toList(), converters -> {
            boolean hasUplink = converters.stream().anyMatch(converterPath -> ConverterType.UPLINK.getDirectory().equals(converterPath.name()));
            boolean hasDownlink = converters.stream().anyMatch(converterPath -> ConverterType.DOWNLINK.getDirectory().equals(converterPath.name()));
            return new LibraryConvertersInfo(hasUplink, hasDownlink);
        })));
    }

    @ConstructorProperties(value={"gitSyncService"})
    @Generated
    public DefaultConverterLibraryService(GitSyncService gitSyncService) {
        this.gitSyncService = gitSyncService;
    }
}

