/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.gen.edge.v1.UserCredentialsUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UserUpdateMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.UserCloudProcessor;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.user.BaseUserProcessor;

@Component
@TbCoreComponent
public class UserCloudProcessor
extends BaseUserProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserCloudProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processUserMsgFromCloud(TenantId tenantId, UserUpdateMsg userUpdateMsg) throws ThingsboardException {
        UserId userId = new UserId(new UUID(userUpdateMsg.getIdMSB(), userUpdateMsg.getIdLSB()));
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            ListenableFuture listenableFuture = switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[userUpdateMsg.getMsgType().ordinal()]) {
                case 1, 2 -> {
                    this.saveOrUpdateUserFromCloud(tenantId, userId, userUpdateMsg);
                    yield this.requestForAdditionalData(tenantId, (EntityId)userId);
                }
                case 3 -> {
                    if (userUpdateMsg.hasEntityGroupIdMSB() && userUpdateMsg.hasEntityGroupIdLSB()) {
                        UUID entityGroupUUID = this.safeGetUUID(userUpdateMsg.getEntityGroupIdMSB(), userUpdateMsg.getEntityGroupIdLSB());
                        EntityGroupId entityGroupId = new EntityGroupId(entityGroupUUID);
                        this.edgeCtx.getEntityGroupService().removeEntityFromEntityGroup(tenantId, entityGroupId, (EntityId)userId);
                        yield this.removeEntityIfInSingleAllGroup(tenantId, (EntityId)userId, () -> this.edgeCtx.getUserService().deleteUser(tenantId, userId));
                    }
                    this.deleteUserAndPushEntityDeletedEventToRuleEngine(tenantId, userId);
                    yield Futures.immediateFuture(null);
                }
                default -> this.handleUnsupportedMsgType(userUpdateMsg.getMsgType());
            };
            return listenableFuture;
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    private void saveOrUpdateUserFromCloud(TenantId tenantId, UserId userId, UserUpdateMsg userUpdateMsg) throws ThingsboardException {
        Boolean userEmailUpdated;
        Pair resultPair = super.saveOrUpdateUser(tenantId, userId, userUpdateMsg);
        Boolean created = (Boolean)resultPair.getFirst();
        if (created.booleanValue()) {
            this.pushUserCreatedEventToRuleEngine(tenantId, userId);
        }
        if ((userEmailUpdated = (Boolean)resultPair.getSecond()).booleanValue()) {
            this.cloudEventService.saveCloudEventAsync(tenantId, CloudEventType.USER, EdgeEventActionType.UPDATED, (EntityId)userId, null, null);
        }
    }

    private void pushUserCreatedEventToRuleEngine(TenantId tenantId, UserId userId) {
        User user = this.edgeCtx.getUserService().findUserById(tenantId, userId);
        this.pushUserEventToRuleEngine(tenantId, user, TbMsgType.ENTITY_CREATED);
    }

    private void pushUserEventToRuleEngine(TenantId tenantId, User user, TbMsgType msgType) {
        try {
            String deviceAsString = JacksonUtil.toString((Object)user);
            this.pushEntityEventToRuleEngine(tenantId, (EntityId)user.getId(), user.getCustomerId(), msgType, deviceAsString, new TbMsgMetaData());
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push user action to rule engine: {}", new Object[]{tenantId, user.getId(), msgType.name(), e});
        }
    }

    public ListenableFuture<Void> processUserCredentialsMsgFromCloud(TenantId tenantId, UserCredentialsUpdateMsg userCredentialsUpdateMsg) {
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            super.updateUserCredentials(tenantId, userCredentialsUpdateMsg);
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
        return Futures.immediateFuture(null);
    }

    public UplinkMsg convertCloudEventToUplink(CloudEvent cloudEvent) {
        UserId userId = new UserId(cloudEvent.getEntityId());
        EntityGroupId entityGroupId = cloudEvent.getEntityGroupId() != null ? new EntityGroupId(cloudEvent.getEntityGroupId()) : null;
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[cloudEvent.getAction().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                User user = this.edgeCtx.getUserService().findUserById(cloudEvent.getTenantId(), userId);
                if (user != null) {
                    UpdateMsgType msgType = this.getUpdateMsgType(cloudEvent.getAction());
                    UplinkMsg.Builder builder = UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addUserUpdateMsg(EdgeMsgConstructorUtils.constructUserUpdatedMsg((UpdateMsgType)msgType, (User)user, (EntityGroupId)entityGroupId));
                    UserCredentials userCredentials = this.edgeCtx.getUserService().findUserCredentialsByUserId(cloudEvent.getTenantId(), userId);
                    if (userCredentials != null) {
                        builder.addUserCredentialsUpdateMsg(EdgeMsgConstructorUtils.constructUserCredentialsUpdatedMsg((UserCredentials)userCredentials));
                    }
                    return builder.build();
                }
                log.info("Skipping event as user was not found [{}]", (Object)cloudEvent);
                break;
            }
            case 4: 
            case 5: {
                UserUpdateMsg userDeleteMsg = EdgeMsgConstructorUtils.constructUserDeleteMsg((UserId)userId, (EntityGroupId)entityGroupId);
                return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addUserUpdateMsg(userDeleteMsg).build();
            }
            case 6: {
                UserCredentials userCredentials = this.edgeCtx.getUserService().findUserCredentialsByUserId(cloudEvent.getTenantId(), userId);
                if (userCredentials == null) break;
                return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addUserCredentialsUpdateMsg(EdgeMsgConstructorUtils.constructUserCredentialsUpdatedMsg((UserCredentials)userCredentials)).build();
            }
        }
        return null;
    }

    public CloudEventType getCloudEventType() {
        return CloudEventType.USER;
    }

    protected void setCustomerId(TenantId tenantId, CustomerId customerId, User user, UserUpdateMsg userUpdateMsg) {
        if (this.isCustomerNotExists(tenantId, user.getCustomerId())) {
            user.setCustomerId(null);
        }
    }
}

