/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileConfiguration;
import org.thingsboard.server.gen.edge.v1.TenantProfileUpdateMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.TenantProfileCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
@TbCoreComponent
public class TenantProfileCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantProfileCloudProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListenableFuture<Void> processTenantProfileMsgFromCloud(TenantId tenantId, TenantProfileUpdateMsg tenantProfileUpdateMsg) {
        TenantProfile tenantProfileMsg = (TenantProfile)JacksonUtil.fromString((String)tenantProfileUpdateMsg.getEntity(), TenantProfile.class, (boolean)true);
        if (tenantProfileMsg == null) {
            throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] tenantProfileUpdateMsg {" + String.valueOf(tenantProfileUpdateMsg) + "} cannot be converted to tenant profile");
        }
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[tenantProfileUpdateMsg.getMsgType().ordinal()]) {
                case 1: {
                    String tenantProfileMsgName = tenantProfileMsg.getName();
                    TenantProfile tenantProfileByName = this.findTenantProfileByName(tenantId, tenantProfileMsgName);
                    boolean removePreviousProfile = false;
                    if (tenantProfileByName != null && !tenantProfileByName.getId().equals((Object)tenantProfileMsg.getId())) {
                        this.renamePreviousTenantProfile(tenantProfileByName);
                        removePreviousProfile = true;
                    }
                    TenantProfile tenantProfile = this.edgeCtx.getTenantProfileService().findTenantProfileById(tenantId, tenantProfileMsg.getId());
                    boolean isDefault = tenantProfileMsg.isDefault();
                    if (tenantProfile == null) {
                        tenantProfileMsg.setDefault(false);
                        this.edgeCtx.getTenantProfileService().saveTenantProfile(TenantId.SYS_TENANT_ID, tenantProfileMsg, false);
                    }
                    if (isDefault) {
                        this.edgeCtx.getTenantProfileService().setDefaultTenantProfile(TenantId.SYS_TENANT_ID, tenantProfileMsg.getId());
                        tenantProfileMsg.setDefault(true);
                    }
                    this.clearRateLimitsProfileConfiguration(tenantProfileMsg);
                    if (removePreviousProfile) {
                        this.updateTenants(tenantProfileMsg.getId(), tenantProfileByName.getId());
                        this.edgeCtx.getTenantProfileService().deleteTenantProfile(tenantId, tenantProfileByName.getId());
                    }
                    TenantProfile savedTenantProfile = this.edgeCtx.getTenantProfileService().saveTenantProfile(TenantId.SYS_TENANT_ID, tenantProfileMsg, false);
                    this.edgeCtx.getTenantProfileCache().put(savedTenantProfile);
                    return Futures.immediateFuture(null);
                }
                case 2: {
                    ListenableFuture listenableFuture = this.handleUnsupportedMsgType(tenantProfileUpdateMsg.getMsgType());
                    return listenableFuture;
                }
            }
            return Futures.immediateFuture(null);
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    private void clearRateLimitsProfileConfiguration(TenantProfile tenantProfile) {
        DefaultTenantProfileConfiguration configuration = (DefaultTenantProfileConfiguration)tenantProfile.getProfileData().getConfiguration();
        configuration.setTransportTenantMsgRateLimit(null);
        configuration.setTransportDeviceMsgRateLimit(null);
        configuration.setTransportTenantTelemetryMsgRateLimit(null);
        configuration.setTransportDeviceTelemetryMsgRateLimit(null);
        configuration.setTransportTenantTelemetryDataPointsRateLimit(null);
        configuration.setTransportDeviceTelemetryDataPointsRateLimit(null);
        configuration.setTenantServerRestLimitsConfiguration(null);
        configuration.setCustomerServerRestLimitsConfiguration(null);
        configuration.setTenantEntityExportRateLimit(null);
        configuration.setTenantEntityImportRateLimit(null);
        configuration.setWsUpdatesPerSessionRateLimit(null);
        configuration.setCassandraReadQueryTenantCoreRateLimits(null);
        configuration.setCassandraWriteQueryTenantCoreRateLimits(null);
        configuration.setCassandraReadQueryTenantRuleEngineRateLimits(null);
        configuration.setCassandraWriteQueryTenantRuleEngineRateLimits(null);
        configuration.setTenantNotificationRequestsRateLimit(null);
        configuration.setTenantNotificationRequestsPerRuleRateLimit(null);
        configuration.setEdgeEventRateLimits(null);
        configuration.setEdgeEventRateLimitsPerEdge(null);
        configuration.setRpcTtlDays(0);
        configuration.setMaxJSExecutions(0L);
        configuration.setMaxREExecutions(0L);
        configuration.setMaxDPStorageDays(0L);
        configuration.setMaxTbelExecutions(0L);
        configuration.setQueueStatsTtlDays(0);
        configuration.setMaxTransportMessages(0L);
        configuration.setDefaultStorageTtlDays(0);
        configuration.setMaxTransportDataPoints(0L);
        configuration.setRuleEngineExceptionsTtlDays(0);
        configuration.setMaxRuleNodeExecutionsPerMessage(0);
        tenantProfile.getProfileData().setConfiguration((TenantProfileConfiguration)configuration);
    }

    private TenantProfile findTenantProfileByName(TenantId tenantId, String name) {
        PageDataIterable tenantProfiles = new PageDataIterable(link -> this.edgeCtx.getTenantProfileService().findTenantProfiles(tenantId, link), 1000);
        for (TenantProfile tenantProfile : tenantProfiles) {
            if (!tenantProfile.getName().equals(name)) continue;
            return tenantProfile;
        }
        return null;
    }

    private void renamePreviousTenantProfile(TenantProfile tenantProfileByName) {
        tenantProfileByName.setName(tenantProfileByName.getName() + StringUtils.randomAlphanumeric((int)15));
        this.edgeCtx.getTenantProfileService().saveTenantProfile(TenantId.SYS_TENANT_ID, tenantProfileByName);
    }

    private void updateTenants(TenantProfileId newTenantProfileId, TenantProfileId oldTenantProfileId) {
        List tenantIdList = this.edgeCtx.getTenantService().findTenantIdsByTenantProfileId(oldTenantProfileId);
        PageDataIterable tenants = new PageDataIterable(link -> this.edgeCtx.getTenantService().findTenants(link), 1000);
        for (Tenant tenant : tenants) {
            if (!tenantIdList.contains(tenant.getId())) continue;
            tenant.setTenantProfileId(newTenantProfileId);
            this.edgeCtx.getTenantService().saveTenant(tenant);
            this.edgeCtx.getTenantProfileCache().evict(tenant.getId());
        }
    }
}

