/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import java.util.ArrayList;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.gen.edge.v1.AttributesRequestMsg;
import org.thingsboard.server.gen.edge.v1.EntityDataProto;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.rpc.processor.telemetry.BaseTelemetryProcessor;

@Component
@TbCoreComponent
public class TelemetryCloudProcessor
extends BaseTelemetryProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelemetryCloudProcessor.class);

    protected String getMsgSourceKey() {
        return "cloud";
    }

    public UplinkMsg convertTelemetryEventToUplink(TenantId tenantId, CloudEvent cloudEvent) {
        log.trace("Executing convertTelemetryEventToUplink, cloudEvent [{}]", (Object)cloudEvent);
        EntityType entityType = EntityType.valueOf((String)cloudEvent.getType().name());
        EntityDataProto entityDataProto = this.convertTelemetryEventToEntityDataProto(tenantId, entityType, cloudEvent.getEntityId(), cloudEvent.getAction(), cloudEvent.getEntityBody());
        return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addEntityData(entityDataProto).build();
    }

    public UplinkMsg convertAttributesRequestEventToUplink(CloudEvent cloudEvent) {
        log.trace("Executing convertAttributesRequestEventToUplink, cloudEvent [{}]", (Object)cloudEvent);
        EntityId entityId = EntityIdFactory.getByCloudEventTypeAndUuid((CloudEventType)cloudEvent.getType(), (UUID)cloudEvent.getEntityId());
        try {
            ArrayList<AttributesRequestMsg> allAttributesRequestMsg = new ArrayList<AttributesRequestMsg>();
            AttributesRequestMsg serverAttributesRequestMsg = AttributesRequestMsg.newBuilder().setEntityIdMSB(entityId.getId().getMostSignificantBits()).setEntityIdLSB(entityId.getId().getLeastSignificantBits()).setEntityType(entityId.getEntityType().name()).setScope("SERVER_SCOPE").build();
            allAttributesRequestMsg.add(serverAttributesRequestMsg);
            if (EntityType.DEVICE.equals((Object)entityId.getEntityType())) {
                AttributesRequestMsg sharedAttributesRequestMsg = AttributesRequestMsg.newBuilder().setEntityIdMSB(entityId.getId().getMostSignificantBits()).setEntityIdLSB(entityId.getId().getLeastSignificantBits()).setEntityType(entityId.getEntityType().name()).setScope("SHARED_SCOPE").build();
                allAttributesRequestMsg.add(sharedAttributesRequestMsg);
            }
            UplinkMsg.Builder builder = UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addAllAttributesRequestMsg(allAttributesRequestMsg);
            return builder.build();
        }
        catch (Exception e) {
            log.warn("Can't send attribute request msg, entityId [{}], body [{}]", new Object[]{cloudEvent.getEntityId(), cloudEvent.getEntityBody(), e});
            return null;
        }
    }
}

