/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.SchedulerEventId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.scheduler.SchedulerEvent;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.gen.edge.v1.SchedulerEventUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.SchedulerEventCloudProcessor;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.scheduler.BaseSchedulerEventProcessor;

@Component
@TbCoreComponent
public class SchedulerEventCloudProcessor
extends BaseSchedulerEventProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulerEventCloudProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListenableFuture<Void> processScheduleEventFromCloud(TenantId tenantId, SchedulerEventUpdateMsg schedulerEventUpdateMsg) {
        SchedulerEventId schedulerEventId = new SchedulerEventId(new UUID(schedulerEventUpdateMsg.getIdMSB(), schedulerEventUpdateMsg.getIdLSB()));
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[schedulerEventUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    Boolean created = super.saveOrUpdateSchedulerEvent(tenantId, schedulerEventId, schedulerEventUpdateMsg);
                    if (created == false) return Futures.immediateFuture(null);
                    this.pushSchedulerEventCreatedEventToRuleEngine(tenantId, schedulerEventId);
                    ListenableFuture listenableFuture = Futures.immediateFuture(null);
                    return listenableFuture;
                }
                case 3: {
                    SchedulerEvent schedulerEventToDelete = this.edgeCtx.getSchedulerEventService().findSchedulerEventById(tenantId, schedulerEventId);
                    if (schedulerEventToDelete == null) return Futures.immediateFuture(null);
                    this.edgeCtx.getSchedulerEventService().deleteSchedulerEvent(tenantId, schedulerEventId);
                    this.pushSchedulerEventDeletedEventToRuleEngine(tenantId, schedulerEventToDelete);
                    return Futures.immediateFuture(null);
                }
                case 4: {
                    ListenableFuture listenableFuture = this.handleUnsupportedMsgType(schedulerEventUpdateMsg.getMsgType());
                    return listenableFuture;
                }
            }
            return Futures.immediateFuture(null);
        }
        catch (Exception e) {
            String errMsg = String.format("Can't process SchedulerEventUpdateMsg [%s]", schedulerEventUpdateMsg);
            log.error(errMsg, (Throwable)e);
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException(errMsg, e));
            return listenableFuture;
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    private void pushSchedulerEventCreatedEventToRuleEngine(TenantId tenantId, SchedulerEventId schedulerEventId) {
        SchedulerEvent schedulerEvent = this.edgeCtx.getSchedulerEventService().findSchedulerEventById(tenantId, schedulerEventId);
        this.pushSchedulerEventToRuleEngine(tenantId, schedulerEvent, TbMsgType.ENTITY_CREATED);
    }

    private void pushSchedulerEventDeletedEventToRuleEngine(TenantId tenantId, SchedulerEvent schedulerEvent) {
        this.pushSchedulerEventToRuleEngine(tenantId, schedulerEvent, TbMsgType.ENTITY_DELETED);
    }

    private void pushSchedulerEventToRuleEngine(TenantId tenantId, SchedulerEvent schedulerEvent, TbMsgType msgType) {
        try {
            String schedulerEventAsString = JacksonUtil.toString((Object)schedulerEvent);
            this.pushEntityEventToRuleEngine(tenantId, (EntityId)schedulerEvent.getId(), null, msgType, schedulerEventAsString, new TbMsgMetaData());
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push scheduler event action to rule engine: {}", new Object[]{tenantId, schedulerEvent.getId(), msgType.name(), e});
        }
    }

    protected boolean isEnabledDuringCreation() {
        return true;
    }

    protected void setCustomerId(TenantId tenantId, CustomerId customerId, SchedulerEvent schedulerEvent) {
        if (this.isCustomerNotExists(tenantId, schedulerEvent.getCustomerId())) {
            schedulerEvent.setCustomerId(null);
        }
    }

    public UplinkMsg convertCloudEventToUplink(CloudEvent cloudEvent) {
        SchedulerEventId schedulerEventId = new SchedulerEventId(cloudEvent.getEntityId());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[cloudEvent.getAction().ordinal()]) {
            case 1: 
            case 2: {
                SchedulerEvent schedulerEvent = this.edgeCtx.getSchedulerEventService().findSchedulerEventById(cloudEvent.getTenantId(), schedulerEventId);
                if (schedulerEvent != null) {
                    UpdateMsgType msgType = this.getUpdateMsgType(cloudEvent.getAction());
                    SchedulerEventUpdateMsg schedulerEventUpdateMsg = EdgeMsgConstructorUtils.constructSchedulerEventUpdatedMsg((UpdateMsgType)msgType, (SchedulerEvent)schedulerEvent);
                    return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addSchedulerEventUpdateMsg(schedulerEventUpdateMsg).build();
                }
                log.info("Skipping event as scheduler event was not found [{}]", (Object)cloudEvent);
                break;
            }
            case 3: {
                SchedulerEventUpdateMsg schedulerEventUpdateMsg = EdgeMsgConstructorUtils.constructSchedulerEventDeleteMsg((SchedulerEventId)schedulerEventId);
                return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addSchedulerEventUpdateMsg(schedulerEventUpdateMsg).build();
            }
        }
        return null;
    }

    public CloudEventType getCloudEventType() {
        return CloudEventType.SCHEDULER_EVENT;
    }
}

