/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainMetaData;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.RuleChainMetadataUpdateMsg;
import org.thingsboard.server.gen.edge.v1.RuleChainUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.RuleChainCloudProcessor;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.rule.BaseRuleChainProcessor;

@Component
@TbCoreComponent
public class RuleChainCloudProcessor
extends BaseRuleChainProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleChainCloudProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListenableFuture<Void> processRuleChainMsgFromCloud(TenantId tenantId, RuleChainUpdateMsg ruleChainUpdateMsg) {
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            RuleChainId ruleChainId = new RuleChainId(new UUID(ruleChainUpdateMsg.getIdMSB(), ruleChainUpdateMsg.getIdLSB()));
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[ruleChainUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    this.saveOrUpdateRuleChain(tenantId, ruleChainId, ruleChainUpdateMsg);
                    ListenableFuture listenableFuture = Futures.immediateFuture(null);
                    return listenableFuture;
                }
                case 3: {
                    RuleChain ruleChainById = this.edgeCtx.getRuleChainService().findRuleChainById(tenantId, ruleChainId);
                    if (ruleChainById != null) {
                        this.edgeCtx.getRuleChainService().deleteRuleChainById(tenantId, ruleChainId);
                    }
                    ListenableFuture listenableFuture = Futures.immediateFuture(null);
                    return listenableFuture;
                }
                case 4: {
                    ListenableFuture listenableFuture = this.handleUnsupportedMsgType(ruleChainUpdateMsg.getMsgType());
                    return listenableFuture;
                }
            }
            return Futures.immediateFuture(null);
        }
        catch (Exception e) {
            String errMsg = String.format("Can't process rule chain update msg %s", ruleChainUpdateMsg);
            log.error(errMsg, (Throwable)e);
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException(errMsg, e));
            return listenableFuture;
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    private void saveOrUpdateRuleChain(TenantId tenantId, RuleChainId ruleChainId, RuleChainUpdateMsg ruleChainUpdateMsg) {
        Pair resultPair = this.saveOrUpdateRuleChain(tenantId, ruleChainId, ruleChainUpdateMsg, RuleChainType.CORE);
        Boolean isRoot = (Boolean)resultPair.getSecond();
        if (isRoot.booleanValue()) {
            this.edgeCtx.getRuleChainService().setRootRuleChain(tenantId, ruleChainId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListenableFuture<Void> processRuleChainMetadataMsgFromCloud(TenantId tenantId, RuleChainMetadataUpdateMsg ruleChainMetadataUpdateMsg) {
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[ruleChainMetadataUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    this.saveOrUpdateRuleChainMetadata(tenantId, ruleChainMetadataUpdateMsg);
                    return Futures.immediateFuture(null);
                }
                case 4: {
                    ListenableFuture listenableFuture = this.handleUnsupportedMsgType(ruleChainMetadataUpdateMsg.getMsgType());
                    return listenableFuture;
                }
            }
            return Futures.immediateFuture(null);
        }
        catch (Exception e) {
            String errMsg = String.format("Can't process rule chain metadata update msg %s", ruleChainMetadataUpdateMsg);
            log.error(errMsg, (Throwable)e);
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException(errMsg, e));
            return listenableFuture;
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    public UplinkMsg convertCloudEventToUplink(CloudEvent cloudEvent) {
        RuleChainId ruleChainId = new RuleChainId(cloudEvent.getEntityId());
        UplinkMsg msg = null;
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[cloudEvent.getAction().ordinal()]) {
            case 1: 
            case 2: {
                RuleChain ruleChain = this.edgeCtx.getRuleChainService().findRuleChainById(cloudEvent.getTenantId(), ruleChainId);
                if (ruleChain != null) {
                    UpdateMsgType msgType = this.getUpdateMsgType(cloudEvent.getAction());
                    RuleChainUpdateMsg ruleChainUpdateMsg = EdgeMsgConstructorUtils.constructRuleChainUpdatedMsg((UpdateMsgType)msgType, (RuleChain)ruleChain, (boolean)ruleChain.isRoot());
                    UplinkMsg.Builder builder = UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addRuleChainUpdateMsg(ruleChainUpdateMsg);
                    RuleChainMetaData ruleChainMetaData = this.edgeCtx.getRuleChainService().loadRuleChainMetaData(cloudEvent.getTenantId(), ruleChainId);
                    RuleChainMetadataUpdateMsg ruleChainMetadataUpdateMsg = EdgeMsgConstructorUtils.constructRuleChainMetadataUpdatedMsg((UpdateMsgType)msgType, (RuleChainMetaData)ruleChainMetaData, (EdgeVersion)EdgeVersion.V_LATEST);
                    builder.addRuleChainMetadataUpdateMsg(ruleChainMetadataUpdateMsg);
                    msg = builder.build();
                    break;
                }
                log.info("Skipping event as asset was not found [{}]", (Object)cloudEvent);
                break;
            }
            case 3: {
                msg = UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addRuleChainUpdateMsg(EdgeMsgConstructorUtils.constructRuleChainDeleteMsg((RuleChainId)ruleChainId)).build();
            }
        }
        return msg;
    }

    public CloudEventType getCloudEventType() {
        return CloudEventType.RULE_CHAIN;
    }
}

