/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.id.RoleId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.role.Role;
import org.thingsboard.server.common.data.role.RoleType;
import org.thingsboard.server.dao.service.validator.RoleDataValidator;
import org.thingsboard.server.gen.edge.v1.RoleProto;
import org.thingsboard.server.service.cloud.rpc.processor.RoleCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.security.permission.UserPermissionsService;

@Component
public class RoleCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoleCloudProcessor.class);
    @Autowired
    private RoleDataValidator roleValidator;
    @Autowired
    private UserPermissionsService userPermissionsService;
    private final Set<Operation> partialUpdateOrReadOperations = new HashSet<Operation>(Arrays.asList(Operation.RPC_CALL, Operation.READ, Operation.READ_ATTRIBUTES, Operation.READ_CREDENTIALS, Operation.READ_TELEMETRY, Operation.WRITE_ATTRIBUTES, Operation.WRITE_TELEMETRY, Operation.WRITE_CREDENTIALS));
    private final Set<Operation> fullEntityUpdateOperations = new HashSet<Operation>(Arrays.asList(Operation.CHANGE_OWNER, Operation.CREATE, Operation.READ, Operation.READ_ATTRIBUTES, Operation.READ_TELEMETRY, Operation.WRITE, Operation.WRITE_ATTRIBUTES, Operation.WRITE_TELEMETRY, Operation.READ_CALCULATED_FIELD, Operation.WRITE_CALCULATED_FIELD));
    private final Set<Operation> edgeOperations = new HashSet<Operation>(Arrays.asList(Operation.READ, Operation.READ_ATTRIBUTES, Operation.READ_TELEMETRY, Operation.WRITE));
    private final Set<Operation> entityGroupOperations = new HashSet<Operation>(Arrays.asList(Operation.ADD_TO_GROUP, Operation.REMOVE_FROM_GROUP, Operation.READ, Operation.READ_ATTRIBUTES, Operation.READ_TELEMETRY, Operation.WRITE_ATTRIBUTES, Operation.WRITE_CREDENTIALS));

    public ListenableFuture<Void> processRoleMsgFromCloud(TenantId tenantId, RoleProto roleProto) {
        try {
            RoleId roleId = new RoleId(new UUID(roleProto.getIdMSB(), roleProto.getIdLSB()));
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[roleProto.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    Role role = (Role)JacksonUtil.fromString((String)roleProto.getEntity(), Role.class, (boolean)true);
                    if (role == null) {
                        throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] roleProto {" + String.valueOf(roleProto) + "} cannot be converted to rolo");
                    }
                    Role roleById = this.edgeCtx.getRoleService().findRoleById(tenantId, roleId);
                    boolean created = false;
                    if (roleById == null) {
                        created = true;
                        role.setId(null);
                    }
                    role = this.replaceWriteOperationsToReadIfRequired(role);
                    this.roleValidator.validate((BaseData)role, Role::getTenantId);
                    if (created) {
                        role.setId((UUIDBased)roleId);
                    }
                    Role savedRole = this.edgeCtx.getRoleService().saveRole(tenantId, role, false);
                    this.userPermissionsService.onRoleUpdated(savedRole);
                    break;
                }
                case 3: {
                    Role roleToDelete = this.edgeCtx.getRoleService().findRoleById(tenantId, roleId);
                    if (roleToDelete == null) break;
                    this.edgeCtx.getRoleService().deleteRole(tenantId, roleId);
                    break;
                }
                case 4: {
                    return this.handleUnsupportedMsgType(roleProto.getMsgType());
                }
            }
        }
        catch (Exception e) {
            String errMsg = String.format("Can't process roleProto [%s]", roleProto);
            log.error(errMsg, (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)new RuntimeException(errMsg, e));
        }
        return Futures.immediateFuture(null);
    }

    Role replaceWriteOperationsToReadIfRequired(Role role) {
        if (RoleType.GROUP.equals((Object)role.getType())) {
            return role;
        }
        CollectionType operationType = TypeFactory.defaultInstance().constructCollectionType(List.class, Operation.class);
        JavaType resourceType = JacksonUtil.OBJECT_MAPPER.getTypeFactory().constructType(Resource.class);
        MapType mapType = TypeFactory.defaultInstance().constructMapType(HashMap.class, resourceType, (JavaType)operationType);
        Map originPermissions = (Map)JacksonUtil.fromString((String)JacksonUtil.toString((Object)role.getPermissions()), (JavaType)mapType);
        if (originPermissions == null) {
            return role;
        }
        HashMap<Resource, List<Object>> newPermissions = new HashMap<Resource, List<Object>>();
        for (Map.Entry entry : originPermissions.entrySet()) {
            List originOperations = (List)entry.getValue();
            newPermissions.put((Resource)entry.getKey(), switch (1.$SwitchMap$org$thingsboard$server$common$data$permission$Resource[((Resource)entry.getKey()).ordinal()]) {
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> (ArrayList)entry.getValue();
                case 12, 13, 14, 15, 16 -> this.filterOperations(originOperations, this.entityGroupOperations);
                case 17, 18 -> new ArrayList();
                case 19, 20, 21, 22 -> this.filterOperations(originOperations, this.fullEntityUpdateOperations);
                case 23 -> this.filterOperations(originOperations, this.edgeOperations);
                case 24 -> {
                    if (originOperations.contains(Operation.ALL)) {
                        newPermissions.put(Resource.PROFILE, new ArrayList());
                        newPermissions.put(Resource.VERSION_CONTROL, new ArrayList());
                        newPermissions.put(Resource.DEVICE, Collections.singletonList(Operation.ALL));
                        newPermissions.put(Resource.ASSET, Collections.singletonList(Operation.ALL));
                        newPermissions.put(Resource.ENTITY_VIEW, Collections.singletonList(Operation.ALL));
                        newPermissions.put(Resource.DASHBOARD, Collections.singletonList(Operation.ALL));
                        newPermissions.put(Resource.ALARM, Collections.singletonList(Operation.ALL));
                        newPermissions.put(Resource.SCHEDULER_EVENT, Collections.singletonList(Operation.ALL));
                        newPermissions.put(Resource.REPORT_TEMPLATE, Collections.singletonList(Operation.ALL));
                        newPermissions.put(Resource.REPORT, Collections.singletonList(Operation.ALL));
                        newPermissions.put(Resource.NOTIFICATION, Collections.singletonList(Operation.ALL));
                        newPermissions.put(Resource.USER, Collections.singletonList(Operation.ALL));
                        newPermissions.put(Resource.AI_MODEL, Collections.singletonList(Operation.ALL));
                        newPermissions.put(Resource.DEVICE_GROUP, new ArrayList(this.entityGroupOperations));
                        newPermissions.put(Resource.ASSET_GROUP, new ArrayList(this.entityGroupOperations));
                        newPermissions.put(Resource.ENTITY_VIEW_GROUP, new ArrayList(this.entityGroupOperations));
                        newPermissions.put(Resource.DASHBOARD_GROUP, new ArrayList(this.entityGroupOperations));
                        newPermissions.put(Resource.USER_GROUP, new ArrayList(this.entityGroupOperations));
                        newPermissions.put(Resource.DEVICE_PROFILE, new ArrayList(this.fullEntityUpdateOperations));
                        newPermissions.put(Resource.ASSET_PROFILE, new ArrayList(this.fullEntityUpdateOperations));
                        newPermissions.put(Resource.TB_RESOURCE, new ArrayList(this.fullEntityUpdateOperations));
                        newPermissions.put(Resource.RULE_CHAIN, new ArrayList(this.fullEntityUpdateOperations));
                        newPermissions.put(Resource.EDGE, new ArrayList(this.edgeOperations));
                        yield new ArrayList(this.partialUpdateOrReadOperations);
                    }
                    yield originOperations.stream().filter(this.partialUpdateOrReadOperations::contains).collect(Collectors.toList());
                }
                default -> this.filterOperations(originOperations, this.partialUpdateOrReadOperations);
            });
        }
        role.setPermissions(JacksonUtil.valueToTree(newPermissions));
        return role;
    }

    private List<Operation> filterOperations(List<Operation> originOperations, Set<Operation> edgeSupportedOperations) {
        if (originOperations.contains(Operation.ALL)) {
            return new ArrayList<Operation>(edgeSupportedOperations);
        }
        return originOperations.stream().filter(edgeSupportedOperations::contains).collect(Collectors.toList());
    }
}

