/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.gen.edge.v1.ResourceUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.ResourceCloudProcessor;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.resource.BaseResourceProcessor;

@Component
@TbCoreComponent
public class ResourceCloudProcessor
extends BaseResourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceCloudProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListenableFuture<Void> processResourceMsgFromCloud(TenantId tenantId, ResourceUpdateMsg resourceUpdateMsg) {
        TbResourceId tbResourceId = new TbResourceId(new UUID(resourceUpdateMsg.getIdMSB(), resourceUpdateMsg.getIdLSB()));
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[resourceUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    TbResource tbResource = (TbResource)JacksonUtil.fromString((String)resourceUpdateMsg.getEntity(), TbResource.class, (boolean)true);
                    if (tbResource == null) {
                        throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] resourceUpdateMsg {" + String.valueOf(resourceUpdateMsg) + "} cannot be converted to tb resource");
                    }
                    this.deleteSystemResourceIfAlreadyExists(tbResourceId, tbResource.getResourceType(), tbResource.getResourceKey());
                    Pair resultPair = this.renamePreviousResource(tenantId, tbResourceId, tbResource.getResourceType(), tbResource.getResourceKey());
                    super.saveOrUpdateTbResource(tenantId, tbResourceId, resourceUpdateMsg);
                    if ((Boolean)resultPair.getFirst() == false) return Futures.immediateFuture(null);
                    this.edgeCtx.getResourceService().deleteResource(tenantId, (TbResourceId)resultPair.getSecond(), true);
                    return Futures.immediateFuture(null);
                }
                case 3: {
                    TbResource tbResourceToDelete = this.edgeCtx.getResourceService().findResourceById(tenantId, tbResourceId);
                    if (tbResourceToDelete == null) return Futures.immediateFuture(null);
                    this.edgeCtx.getResourceService().deleteResource(tenantId, tbResourceId, true);
                    return Futures.immediateFuture(null);
                }
                case 4: {
                    ListenableFuture listenableFuture = this.handleUnsupportedMsgType(resourceUpdateMsg.getMsgType());
                    return listenableFuture;
                }
            }
            return Futures.immediateFuture(null);
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    private Pair<Boolean, TbResourceId> renamePreviousResource(TenantId tenantId, TbResourceId tbResourceId, ResourceType resourceType, String resourceKey) {
        PageDataIterable resourcesIterable = new PageDataIterable(link -> this.edgeCtx.getResourceService().findTenantResourcesByResourceTypeAndPageLink(tenantId, resourceType, link), 1024);
        for (TbResource tbResource : resourcesIterable) {
            if (!tbResource.getResourceKey().equals(resourceKey) || tbResourceId.equals((Object)tbResource.getId())) continue;
            tbResource.setResourceKey(StringUtils.randomAlphanumeric((int)15) + resourceKey);
            this.edgeCtx.getResourceService().saveResource(tbResource, false);
            return Pair.of((Object)true, (Object)tbResource.getId());
        }
        return Pair.of((Object)false, (Object)new TbResourceId(UUID.randomUUID()));
    }

    private void deleteSystemResourceIfAlreadyExists(TbResourceId tbResourceId, ResourceType resourceType, String resourceKey) {
        PageDataIterable entityIdsIterator = new PageDataIterable(link -> this.edgeCtx.getResourceService().findAllTenantResources(TenantId.SYS_TENANT_ID, link), 1024);
        for (TbResource resource : entityIdsIterator) {
            if (!resource.getResourceType().equals((Object)resourceType) || !resource.getResourceKey().equals(resourceKey) || resource.getId().equals((Object)tbResourceId)) continue;
            this.edgeCtx.getResourceService().deleteResource(TenantId.SYS_TENANT_ID, resource.getId(), true);
            break;
        }
    }

    public UplinkMsg convertCloudEventToUplink(CloudEvent cloudEvent) {
        TbResourceId tbResourceId = new TbResourceId(cloudEvent.getEntityId());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[cloudEvent.getAction().ordinal()]) {
            case 1: 
            case 2: {
                TbResource tbResource = this.edgeCtx.getResourceService().findResourceById(cloudEvent.getTenantId(), tbResourceId);
                if (tbResource == null) break;
                UpdateMsgType msgType = this.getUpdateMsgType(cloudEvent.getAction());
                ResourceUpdateMsg resourceUpdateMsg = EdgeMsgConstructorUtils.constructResourceUpdatedMsg((UpdateMsgType)msgType, (TbResource)tbResource);
                return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addResourceUpdateMsg(resourceUpdateMsg).build();
            }
        }
        return null;
    }

    public CloudEventType getCloudEventType() {
        return CloudEventType.TB_RESOURCE;
    }
}

