/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.gen.edge.v1.RelationRequestMsg;
import org.thingsboard.server.gen.edge.v1.RelationUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.relation.BaseRelationProcessor;

@Component
@TbCoreComponent
public class RelationCloudProcessor
extends BaseRelationProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RelationCloudProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processRelationMsgFromCloud(TenantId tenantId, RelationUpdateMsg relationUpdateMsg) {
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            ListenableFuture listenableFuture = this.processRelationMsg(tenantId, relationUpdateMsg);
            return listenableFuture;
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    public UplinkMsg convertRelationRequestEventToUplink(CloudEvent cloudEvent) {
        EntityId entityId = EntityIdFactory.getByCloudEventTypeAndUuid((CloudEventType)cloudEvent.getType(), (UUID)cloudEvent.getEntityId());
        RelationRequestMsg relationRequestMsg = RelationRequestMsg.newBuilder().setEntityIdMSB(entityId.getId().getMostSignificantBits()).setEntityIdLSB(entityId.getId().getLeastSignificantBits()).setEntityType(entityId.getEntityType().name()).build();
        UplinkMsg.Builder builder = UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addRelationRequestMsg(relationRequestMsg);
        return builder.build();
    }

    public UplinkMsg convertCloudEventToUplink(CloudEvent cloudEvent) {
        UpdateMsgType msgType = this.getUpdateMsgType(cloudEvent.getAction());
        EntityRelation entityRelation = (EntityRelation)JacksonUtil.convertValue((Object)cloudEvent.getEntityBody(), EntityRelation.class);
        if (entityRelation != null) {
            RelationUpdateMsg relationUpdateMsg = EdgeMsgConstructorUtils.constructRelationUpdatedMsg((UpdateMsgType)msgType, (EntityRelation)entityRelation);
            return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addRelationUpdateMsg(relationUpdateMsg).build();
        }
        return null;
    }

    public CloudEventType getCloudEventType() {
        return CloudEventType.RELATION;
    }
}

