/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.OtaPackage;
import org.thingsboard.server.common.data.OtaPackageInfo;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.gen.edge.v1.OtaPackageUpdateMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.OtaPackageCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
@TbCoreComponent
public class OtaPackageCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OtaPackageCloudProcessor.class);
    private final Lock otaPackageCreationLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListenableFuture<Void> processOtaPackageMsgFromCloud(TenantId tenantId, OtaPackageUpdateMsg otaPackageUpdateMsg) {
        OtaPackageId otaPackageId = new OtaPackageId(new UUID(otaPackageUpdateMsg.getIdMSB(), otaPackageUpdateMsg.getIdLSB()));
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[otaPackageUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    this.otaPackageCreationLock.lock();
                    try {
                        OtaPackage otaPackage = (OtaPackage)JacksonUtil.fromString((String)otaPackageUpdateMsg.getEntity(), OtaPackage.class, (boolean)true);
                        if (otaPackage == null) {
                            throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] otaPackageUpdateMsg {" + String.valueOf(otaPackageUpdateMsg) + "} cannot be converted to ota package");
                        }
                        if (otaPackage.getData() == null) {
                            this.edgeCtx.getOtaPackageService().saveOtaPackageInfo(new OtaPackageInfo((OtaPackageInfo)otaPackage), otaPackage.hasUrl(), false);
                            return Futures.immediateFuture(null);
                        }
                        this.edgeCtx.getOtaPackageService().saveOtaPackage(otaPackage, false);
                        return Futures.immediateFuture(null);
                    }
                    finally {
                        this.otaPackageCreationLock.unlock();
                    }
                }
                case 3: {
                    OtaPackage otaPackage = this.edgeCtx.getOtaPackageService().findOtaPackageById(tenantId, otaPackageId);
                    if (otaPackage == null) return Futures.immediateFuture(null);
                    this.edgeCtx.getOtaPackageService().deleteOtaPackage(tenantId, otaPackageId);
                    return Futures.immediateFuture(null);
                }
                case 4: {
                    ListenableFuture listenableFuture = this.handleUnsupportedMsgType(otaPackageUpdateMsg.getMsgType());
                    return listenableFuture;
                }
            }
            return Futures.immediateFuture(null);
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }
}

