/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.domain.Domain;
import org.thingsboard.server.common.data.domain.DomainInfo;
import org.thingsboard.server.common.data.id.DomainId;
import org.thingsboard.server.common.data.id.IdBased;
import org.thingsboard.server.common.data.id.OAuth2ClientId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.oauth2.OAuth2Client;
import org.thingsboard.server.gen.edge.v1.OAuth2ClientUpdateMsg;
import org.thingsboard.server.gen.edge.v1.OAuth2DomainUpdateMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.OAuth2CloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
@TbCoreComponent
public class OAuth2CloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth2CloudProcessor.class);

    public ListenableFuture<Void> processOAuth2ClientMsgFromCloud(OAuth2ClientUpdateMsg oAuth2ClientUpdateMsg) {
        try {
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[oAuth2ClientUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    OAuth2Client oAuth2Client = (OAuth2Client)JacksonUtil.fromString((String)oAuth2ClientUpdateMsg.getEntity(), OAuth2Client.class, (boolean)true);
                    if (oAuth2Client == null) {
                        throw new RuntimeException("[{" + String.valueOf(TenantId.SYS_TENANT_ID) + "}] oAuth2ClientUpdateMsg {" + String.valueOf(oAuth2ClientUpdateMsg) + "} cannot be converted to OAuth2Client");
                    }
                    oAuth2Client.getMapperConfig().setActivateUser(false);
                    oAuth2Client.getMapperConfig().setAllowUserCreation(false);
                    this.edgeCtx.getOAuth2ClientService().saveOAuth2Client(oAuth2Client.getTenantId(), oAuth2Client);
                    return Futures.immediateFuture(null);
                }
                case 3: {
                    OAuth2ClientId oAuth2ClientId = new OAuth2ClientId(new UUID(oAuth2ClientUpdateMsg.getIdMSB(), oAuth2ClientUpdateMsg.getIdLSB()));
                    OAuth2Client oAuth2ClientById = this.edgeCtx.getOAuth2ClientService().findOAuth2ClientById(TenantId.SYS_TENANT_ID, oAuth2ClientId);
                    if (oAuth2ClientById != null) {
                        this.edgeCtx.getOAuth2ClientService().deleteOAuth2ClientById(TenantId.SYS_TENANT_ID, oAuth2ClientId);
                    }
                    return Futures.immediateFuture(null);
                }
                case 4: {
                    return this.handleUnsupportedMsgType(oAuth2ClientUpdateMsg.getMsgType());
                }
            }
        }
        catch (Exception e) {
            String errMsg = String.format("Can't process oAuth2 client update msg %s", oAuth2ClientUpdateMsg);
            log.error(errMsg, (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)new RuntimeException(errMsg, e));
        }
        return Futures.immediateFuture(null);
    }

    public ListenableFuture<Void> processDomainMsgFromCloud(OAuth2DomainUpdateMsg oAuth2DomainUpdateMsg) {
        try {
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[oAuth2DomainUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    Domain domain = (Domain)JacksonUtil.fromString((String)oAuth2DomainUpdateMsg.getEntity(), Domain.class, (boolean)true);
                    if (domain == null) {
                        throw new RuntimeException("[{" + String.valueOf(TenantId.SYS_TENANT_ID) + "}] oAuth2DomainUpdateMsg {" + String.valueOf(oAuth2DomainUpdateMsg) + "} cannot be converted to Domain");
                    }
                    DomainInfo domainInfo = (DomainInfo)JacksonUtil.fromString((String)oAuth2DomainUpdateMsg.getEntity(), DomainInfo.class, (boolean)true);
                    if (domainInfo == null) {
                        throw new RuntimeException("[{" + String.valueOf(TenantId.SYS_TENANT_ID) + "}] oAuth2DomainUpdateMsg {" + String.valueOf(oAuth2DomainUpdateMsg) + "} cannot be converted to DomainInfo");
                    }
                    if (domain.isOauth2Enabled() && !domain.isPropagateToEdge()) {
                        domain.setOauth2Enabled(false);
                    }
                    Domain savedDomain = this.edgeCtx.getDomainService().saveDomain(TenantId.SYS_TENANT_ID, domain);
                    List oAuth2Clients = domainInfo.getOauth2ClientInfos().stream().map(IdBased::getId).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(oAuth2Clients)) {
                        this.edgeCtx.getDomainService().updateOauth2Clients(savedDomain.getTenantId(), (DomainId)savedDomain.getId(), oAuth2Clients);
                    }
                    return Futures.immediateFuture(null);
                }
                case 3: {
                    DomainId domainId = new DomainId(new UUID(oAuth2DomainUpdateMsg.getIdMSB(), oAuth2DomainUpdateMsg.getIdLSB()));
                    Domain domain = this.edgeCtx.getDomainService().findDomainById(TenantId.SYS_TENANT_ID, domainId);
                    if (domain != null) {
                        this.edgeCtx.getDomainService().deleteDomainById(TenantId.SYS_TENANT_ID, domainId);
                    }
                    return Futures.immediateFuture(null);
                }
                case 4: {
                    return this.handleUnsupportedMsgType(oAuth2DomainUpdateMsg.getMsgType());
                }
            }
        }
        catch (Exception e) {
            String errMsg = String.format("Can't process domain update msg %s", oAuth2DomainUpdateMsg);
            log.error(errMsg, (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)new RuntimeException(errMsg, e));
        }
        return Futures.immediateFuture(null);
    }
}

