/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.id.NotificationRuleId;
import org.thingsboard.server.common.data.id.NotificationTargetId;
import org.thingsboard.server.common.data.id.NotificationTemplateId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.rule.NotificationRule;
import org.thingsboard.server.common.data.notification.targets.NotificationTarget;
import org.thingsboard.server.common.data.notification.template.NotificationTemplate;
import org.thingsboard.server.dao.notification.NotificationRuleService;
import org.thingsboard.server.dao.notification.NotificationTargetService;
import org.thingsboard.server.dao.notification.NotificationTemplateService;
import org.thingsboard.server.gen.edge.v1.NotificationRuleUpdateMsg;
import org.thingsboard.server.gen.edge.v1.NotificationTargetUpdateMsg;
import org.thingsboard.server.gen.edge.v1.NotificationTemplateUpdateMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.NotificationCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
@TbCoreComponent
public class NotificationCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificationCloudProcessor.class);

    public ListenableFuture<Void> processNotificationRuleMsgFromCloud(TenantId tenantId, NotificationRuleUpdateMsg notificationRuleUpdateMsg) {
        switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[notificationRuleUpdateMsg.getMsgType().ordinal()]) {
            case 1: 
            case 2: {
                NotificationRule notificationRule = (NotificationRule)JacksonUtil.fromString((String)notificationRuleUpdateMsg.getEntity(), NotificationRule.class, (boolean)true);
                if (notificationRule == null) {
                    throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] notificationRuleUpdateMsg {" + String.valueOf(notificationRuleUpdateMsg) + "} cannot be converted to notification rule");
                }
                NotificationRuleService notificationRuleService = this.edgeCtx.getNotificationRuleService();
                Optional edgeNotificationRule = notificationRuleService.findNotificationRuleByTenantIdAndName(tenantId, notificationRule.getName());
                edgeNotificationRule.filter(rule -> !((NotificationRuleId)rule.getId()).equals((Object)notificationRule.getId())).ifPresent(rule -> notificationRuleService.deleteNotificationRuleById(tenantId, (NotificationRuleId)rule.getId()));
                notificationRuleService.saveNotificationRule(tenantId, notificationRule);
                return Futures.immediateFuture(null);
            }
            case 3: {
                NotificationRuleId notificationRuleId = new NotificationRuleId(new UUID(notificationRuleUpdateMsg.getIdMSB(), notificationRuleUpdateMsg.getIdLSB()));
                NotificationRule notificationRuleToDelete = this.edgeCtx.getNotificationRuleService().findNotificationRuleById(tenantId, notificationRuleId);
                if (notificationRuleToDelete != null) {
                    this.edgeCtx.getNotificationRuleService().deleteNotificationRuleById(tenantId, notificationRuleId);
                }
                return Futures.immediateFuture(null);
            }
        }
        return this.handleUnsupportedMsgType(notificationRuleUpdateMsg.getMsgType());
    }

    public ListenableFuture<Void> processNotificationTargetMsgFromCloud(TenantId tenantId, NotificationTargetUpdateMsg notificationTargetUpdateMsg) {
        switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[notificationTargetUpdateMsg.getMsgType().ordinal()]) {
            case 1: 
            case 2: {
                NotificationTarget notificationTarget = (NotificationTarget)JacksonUtil.fromString((String)notificationTargetUpdateMsg.getEntity(), NotificationTarget.class, (boolean)true);
                if (notificationTarget == null) {
                    throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] notificationTargetUpdateMsg {" + String.valueOf(notificationTargetUpdateMsg) + "} cannot be converted to notification target");
                }
                NotificationTargetService notificationTargetService = this.edgeCtx.getNotificationTargetService();
                Optional edgeNotificationTarget = notificationTargetService.findNotificationTargetByTenantIdAndName(tenantId, notificationTarget.getName());
                edgeNotificationTarget.filter(target -> !((NotificationTargetId)target.getId()).equals((Object)notificationTarget.getId())).ifPresent(target -> notificationTargetService.deleteNotificationTargetById(tenantId, (NotificationTargetId)target.getId()));
                notificationTargetService.saveNotificationTarget(tenantId, notificationTarget);
                return Futures.immediateFuture(null);
            }
            case 3: {
                NotificationTargetId notificationTargetId = new NotificationTargetId(new UUID(notificationTargetUpdateMsg.getIdMSB(), notificationTargetUpdateMsg.getIdLSB()));
                NotificationTarget notificationTargetToDelete = this.edgeCtx.getNotificationTargetService().findNotificationTargetById(tenantId, notificationTargetId);
                if (notificationTargetToDelete != null) {
                    this.edgeCtx.getNotificationTargetService().deleteNotificationTargetById(tenantId, notificationTargetId);
                }
                return Futures.immediateFuture(null);
            }
        }
        return this.handleUnsupportedMsgType(notificationTargetUpdateMsg.getMsgType());
    }

    public ListenableFuture<Void> processNotificationTemplateMsgFromCloud(TenantId tenantId, NotificationTemplateUpdateMsg notificationTemplateUpdateMsg) {
        switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[notificationTemplateUpdateMsg.getMsgType().ordinal()]) {
            case 1: 
            case 2: {
                NotificationTemplate notificationTemplate = (NotificationTemplate)JacksonUtil.fromString((String)notificationTemplateUpdateMsg.getEntity(), NotificationTemplate.class, (boolean)true);
                if (notificationTemplate == null) {
                    throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] notificationTemplateUpdateMsg {" + String.valueOf(notificationTemplateUpdateMsg) + "} cannot be converted to notification template");
                }
                NotificationTemplateService notificationTemplateService = this.edgeCtx.getNotificationTemplateService();
                Optional edgeNotificationTemplate = notificationTemplateService.findNotificationTemplateByTenantIdAndName(tenantId, notificationTemplate.getName());
                edgeNotificationTemplate.filter(template -> !((NotificationTemplateId)template.getId()).equals((Object)notificationTemplate.getId())).ifPresent(template -> notificationTemplateService.deleteNotificationTemplateById(tenantId, (NotificationTemplateId)template.getId()));
                notificationTemplateService.saveNotificationTemplate(tenantId, notificationTemplate);
                return Futures.immediateFuture(null);
            }
            case 3: {
                NotificationTemplateId notificationTemplateId = new NotificationTemplateId(new UUID(notificationTemplateUpdateMsg.getIdMSB(), notificationTemplateUpdateMsg.getIdLSB()));
                NotificationTemplate notificationTemplateToDelete = this.edgeCtx.getNotificationTemplateService().findNotificationTemplateById(tenantId, notificationTemplateId);
                if (notificationTemplateToDelete != null) {
                    this.edgeCtx.getNotificationTemplateService().deleteNotificationTemplateById(tenantId, notificationTemplateId);
                }
                return Futures.immediateFuture(null);
            }
        }
        return this.handleUnsupportedMsgType(notificationTemplateUpdateMsg.getMsgType());
    }
}

