/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.integration.AbstractIntegration;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.dao.service.validator.IntegrationDataValidator;
import org.thingsboard.server.gen.edge.v1.IntegrationUpdateMsg;
import org.thingsboard.server.service.cloud.rpc.processor.IntegrationCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
public class IntegrationCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegrationCloudProcessor.class);
    @Autowired
    private IntegrationDataValidator integrationValidator;

    public ListenableFuture<Void> processIntegrationMsgFromCloud(TenantId tenantId, IntegrationUpdateMsg integrationUpdateMsg) {
        try {
            IntegrationId integrationId = new IntegrationId(new UUID(integrationUpdateMsg.getIdMSB(), integrationUpdateMsg.getIdLSB()));
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[integrationUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    Integration integration = (Integration)JacksonUtil.fromString((String)integrationUpdateMsg.getEntity(), Integration.class, (boolean)true);
                    if (integration == null) {
                        throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] integrationUpdateMsg {" + String.valueOf(integrationUpdateMsg) + "} cannot be converted to integration");
                    }
                    Integration integrationById = this.edgeCtx.getIntegrationService().findIntegrationById(tenantId, integrationId);
                    boolean created = false;
                    if (integrationById == null) {
                        created = true;
                        integration.setId(null);
                    }
                    integration.setEdgeTemplate(false);
                    this.integrationValidator.validate((BaseData)integration, AbstractIntegration::getTenantId);
                    if (created) {
                        integration.setId((UUIDBased)integrationId);
                    }
                    Integration savedIntegration = this.edgeCtx.getIntegrationService().saveIntegration(integration, false);
                    this.edgeCtx.getClusterService().broadcastEntityStateChangeEvent(savedIntegration.getTenantId(), (EntityId)savedIntegration.getId(), created ? ComponentLifecycleEvent.CREATED : ComponentLifecycleEvent.UPDATED);
                    this.cleanUpUnusedConverters(tenantId);
                    break;
                }
                case 3: {
                    Integration integrationToDelete = this.edgeCtx.getIntegrationService().findIntegrationById(tenantId, integrationId);
                    if (integrationToDelete == null) break;
                    this.edgeCtx.getIntegrationService().deleteIntegration(tenantId, integrationId);
                    this.edgeCtx.getClusterService().broadcastEntityStateChangeEvent(integrationToDelete.getTenantId(), (EntityId)integrationToDelete.getId(), ComponentLifecycleEvent.DELETED);
                    this.cleanUpUnusedConverters(tenantId);
                    break;
                }
                case 4: {
                    return this.handleUnsupportedMsgType(integrationUpdateMsg.getMsgType());
                }
            }
        }
        catch (Exception e) {
            String errMsg = String.format("Can't process integration msg [%s]", integrationUpdateMsg);
            log.error(errMsg, (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)new RuntimeException(errMsg, e));
        }
        return Futures.immediateFuture(null);
    }

    private void cleanUpUnusedConverters(TenantId tenantId) {
        PageData pageData;
        ArrayList tenantConverters = new ArrayList();
        PageLink pageLink = new PageLink(100);
        do {
            pageData = this.edgeCtx.getConverterService().findTenantConverters(tenantId, null, pageLink);
            tenantConverters.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        for (Converter tenantConverter : tenantConverters) {
            this.cleanUpUnusedConverters(tenantId, tenantConverter.getId());
        }
    }

    private void cleanUpUnusedConverters(TenantId tenantId, ConverterId converterId) {
        List integrationsByConverterId = this.edgeCtx.getIntegrationService().findIntegrationsByConverterId(tenantId, converterId);
        if (integrationsByConverterId.isEmpty()) {
            this.edgeCtx.getConverterService().deleteConverter(tenantId, converterId);
            this.edgeCtx.getClusterService().broadcastEntityStateChangeEvent(tenantId, (EntityId)converterId, ComponentLifecycleEvent.DELETED);
        }
    }
}

