/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.gen.edge.v1.EntityGroupRequestMsg;
import org.thingsboard.server.gen.edge.v1.EntityGroupUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.service.cloud.rpc.processor.EntityGroupCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
public class EntityGroupCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityGroupCloudProcessor.class);
    private final Lock entityGroupCreationLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processEntityGroupMsgFromCloud(TenantId tenantId, EntityGroupUpdateMsg entityGroupUpdateMsg) {
        EntityGroupId entityGroupId = new EntityGroupId(new UUID(entityGroupUpdateMsg.getIdMSB(), entityGroupUpdateMsg.getIdLSB()));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        EntityGroup entityGroup = null;
        if ((UpdateMsgType.ENTITY_CREATED_RPC_MESSAGE.equals((Object)entityGroupUpdateMsg.getMsgType()) || UpdateMsgType.ENTITY_UPDATED_RPC_MESSAGE.equals((Object)entityGroupUpdateMsg.getMsgType())) && (entityGroup = (EntityGroup)JacksonUtil.fromString((String)entityGroupUpdateMsg.getEntity(), EntityGroup.class, (boolean)true)) == null) {
            throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] entityGroupUpdateMsg {" + String.valueOf(entityGroupUpdateMsg) + "} cannot be converted to entity group");
        }
        boolean edgeGroupAll = EdgeUtils.isEdgeGroupAll((String)entityGroupUpdateMsg.getName());
        if (!edgeGroupAll) {
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[entityGroupUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    this.entityGroupCreationLock.lock();
                    try {
                        this.edgeCtx.getEntityGroupService().saveEntityGroup(tenantId, entityGroup.getOwnerId(), entityGroup, false);
                        break;
                    }
                    finally {
                        this.entityGroupCreationLock.unlock();
                    }
                }
                case 3: {
                    ListenableFuture entityGroupByIdAsyncFuture = this.edgeCtx.getEntityGroupService().findEntityGroupByIdAsync(tenantId, entityGroupId);
                    ListenableFuture deleteFuture = Futures.transformAsync((ListenableFuture)entityGroupByIdAsyncFuture, entityGroupFromDb -> {
                        if (entityGroupFromDb != null) {
                            return this.findAllGroupEntitiesAndRemoveIfRequired(tenantId, entityGroupId);
                        }
                        log.trace("[{}] Entity group was not found [{}]", (Object)tenantId, (Object)entityGroupUpdateMsg);
                        return Futures.immediateFuture(null);
                    }, (Executor)this.dbCallbackExecutorService);
                    futures.add(deleteFuture);
                    break;
                }
                case 4: {
                    return this.handleUnsupportedMsgType(entityGroupUpdateMsg.getMsgType());
                }
            }
        }
        if (entityGroup != null) {
            ObjectNode body = JacksonUtil.newObjectNode();
            body.put("type", entityGroup.getType().name());
            futures.add(this.cloudEventService.saveCloudEventAsync(tenantId, CloudEventType.ENTITY_GROUP, EdgeEventActionType.GROUP_ENTITIES_REQUEST, (EntityId)entityGroupId, (JsonNode)body, null));
            if (!edgeGroupAll) {
                futures.add(this.cloudEventService.saveCloudEventAsync(tenantId, CloudEventType.ENTITY_GROUP, EdgeEventActionType.GROUP_PERMISSIONS_REQUEST, (EntityId)entityGroupId, (JsonNode)body, null));
            }
        }
        return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)this.dbCallbackExecutorService);
    }

    private ListenableFuture<Void> findAllGroupEntitiesAndRemoveIfRequired(TenantId tenantId, EntityGroupId entityGroupId) {
        ListenableFuture entityIdsFuture = this.edgeCtx.getEntityGroupService().findAllEntityIdsAsync(tenantId, entityGroupId, (PageLink)new TimePageLink(Integer.MAX_VALUE));
        return Futures.transformAsync((ListenableFuture)entityIdsFuture, entityIds -> {
            ArrayList<ListenableFuture> deleteEntitiesFutures = new ArrayList<ListenableFuture>();
            if (entityIds != null && !entityIds.isEmpty()) {
                for (EntityId entityId : entityIds) {
                    deleteEntitiesFutures.add(this.removeIfOnlyInAllGroup(tenantId, entityId, entityGroupId));
                }
            }
            ListenableFuture allFuture = Futures.allAsList(deleteEntitiesFutures);
            return Futures.transform((ListenableFuture)allFuture, all -> {
                this.edgeCtx.getEntityGroupService().deleteEntityGroup(tenantId, entityGroupId);
                return null;
            }, (Executor)this.dbCallbackExecutorService);
        }, (Executor)this.dbCallbackExecutorService);
    }

    private ListenableFuture<Void> removeIfOnlyInAllGroup(TenantId tenantId, EntityId entityId, EntityGroupId entityGroupId) {
        ListenableFuture entityGroupsForEntityFuture = this.edgeCtx.getEntityGroupService().findEntityGroupsForEntityAsync(tenantId, entityId);
        return Futures.transform((ListenableFuture)entityGroupsForEntityFuture, entityGroupIds -> {
            if (entityGroupIds != null && entityGroupIds.contains(entityGroupId) && entityGroupIds.size() == 2) {
                try {
                    this.cloudSynchronizationManager.getSync().set(true);
                    this.deleteEntityById(tenantId, entityId);
                }
                finally {
                    this.cloudSynchronizationManager.getSync().remove();
                }
            }
            return null;
        }, (Executor)this.dbCallbackExecutorService);
    }

    private void deleteEntityById(TenantId tenantId, EntityId entityId) {
        switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityId.getEntityType().ordinal()]) {
            case 1: {
                Device deviceToDelete = this.edgeCtx.getDeviceService().findDeviceById(tenantId, new DeviceId(entityId.getId()));
                if (deviceToDelete == null) break;
                this.edgeCtx.getDeviceService().deleteDevice(tenantId, deviceToDelete.getId());
                break;
            }
            case 2: {
                Asset assetToDelete = this.edgeCtx.getAssetService().findAssetById(tenantId, new AssetId(entityId.getId()));
                if (assetToDelete == null) break;
                this.edgeCtx.getAssetService().deleteAsset(tenantId, assetToDelete.getId());
                break;
            }
            case 3: {
                EntityView entityViewToDelete = this.edgeCtx.getEntityViewService().findEntityViewById(tenantId, new EntityViewId(entityId.getId()));
                if (entityViewToDelete == null) break;
                this.edgeCtx.getEntityViewService().deleteEntityView(tenantId, entityViewToDelete.getId());
                break;
            }
            case 4: {
                User userToDelete = this.edgeCtx.getUserService().findUserById(tenantId, new UserId(entityId.getId()));
                if (userToDelete == null) break;
                this.edgeCtx.getUserService().deleteUser(tenantId, userToDelete.getId());
                break;
            }
            case 5: {
                Dashboard dashboardToDelete = this.edgeCtx.getDashboardService().findDashboardById(tenantId, new DashboardId(entityId.getId()));
                if (dashboardToDelete == null) break;
                this.edgeCtx.getDashboardService().deleteDashboard(tenantId, dashboardToDelete.getId());
            }
        }
    }

    public UplinkMsg processGroupEntitiesRequestMsgToCloud(CloudEvent cloudEvent) {
        EntityId entityGroupId = EntityIdFactory.getByCloudEventTypeAndUuid((CloudEventType)cloudEvent.getType(), (UUID)cloudEvent.getEntityId());
        String type = cloudEvent.getEntityBody().get("type").asText();
        EntityGroupRequestMsg entityGroupEntitiesRequestMsg = EntityGroupRequestMsg.newBuilder().setEntityGroupIdMSB(entityGroupId.getId().getMostSignificantBits()).setEntityGroupIdLSB(entityGroupId.getId().getLeastSignificantBits()).setType(type).build();
        UplinkMsg.Builder builder = UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addEntityGroupEntitiesRequestMsg(entityGroupEntitiesRequestMsg);
        return builder.build();
    }
}

