/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.encryptionkey.EncryptionKey;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.gen.edge.v1.EncryptionKeyUpdateMsg;
import org.thingsboard.server.service.cloud.rpc.processor.EncryptionKeyCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
public class EncryptionKeyCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptionKeyCloudProcessor.class);

    public ListenableFuture<Void> processEncryptionKeyMsgFromCloud(TenantId tenantId, EncryptionKeyUpdateMsg keyMsg) {
        switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[keyMsg.getMsgType().ordinal()]) {
            case 1: 
            case 2: {
                try {
                    EncryptionKey key = (EncryptionKey)JacksonUtil.fromString((String)keyMsg.getEntity(), EncryptionKey.class, (boolean)true);
                    if (key == null) {
                        throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] encryptionKeyUpdateMsg {" + String.valueOf(keyMsg) + " } cannot be converted to encryptionKey");
                    }
                    this.edgeCtx.getEncryptionService().save(tenantId, key);
                    break;
                }
                catch (Exception e) {
                    log.error("[{}] Failed to process encryption key update msg [{}]", new Object[]{tenantId, keyMsg, e});
                    throw e;
                }
            }
            case 3: {
                this.edgeCtx.getEncryptionService().deleteEncryptionKeyByTenantId(tenantId);
                break;
            }
            default: {
                log.warn("[{}] Unsupported msg type [{}] for encryption key", (Object)tenantId, (Object)keyMsg.getMsgType());
            }
        }
        return Futures.immediateFuture(null);
    }
}

