/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.DashboardInfo;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceInfoFilter;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.gen.edge.v1.DeviceProfileUpdateMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.DeviceProfileCloudProcessor;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.device.profile.BaseDeviceProfileProcessor;

@Component
@TbCoreComponent
public class DeviceProfileCloudProcessor
extends BaseDeviceProfileProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceProfileCloudProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListenableFuture<Void> processDeviceProfileMsgFromCloud(TenantId tenantId, DeviceProfileUpdateMsg deviceProfileUpdateMsg) {
        DeviceProfileId deviceProfileId = new DeviceProfileId(new UUID(deviceProfileUpdateMsg.getIdMSB(), deviceProfileUpdateMsg.getIdLSB()));
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[deviceProfileUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    deviceCreationLock.lock();
                    try {
                        DeviceProfile deviceProfileMsg = (DeviceProfile)JacksonUtil.fromString((String)deviceProfileUpdateMsg.getEntity(), DeviceProfile.class, (boolean)true);
                        if (deviceProfileMsg == null) {
                            throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] deviceProfileUpdateMsg {" + String.valueOf(deviceProfileUpdateMsg) + "} cannot be converted to device profile");
                        }
                        DeviceProfile deviceProfileByName = this.edgeCtx.getDeviceProfileService().findDeviceProfileByName(tenantId, deviceProfileMsg.getName());
                        boolean removePreviousProfile = false;
                        if (deviceProfileByName != null && !deviceProfileByName.getId().equals((Object)deviceProfileId)) {
                            this.renameExistingOnEdgeDeviceProfile(deviceProfileByName);
                            removePreviousProfile = true;
                        }
                        Pair resultPair = super.saveOrUpdateDeviceProfile(tenantId, deviceProfileId, deviceProfileUpdateMsg);
                        boolean created = (Boolean)resultPair.getFirst();
                        DeviceProfile deviceProfile = this.edgeCtx.getDeviceProfileService().findDeviceProfileById(tenantId, deviceProfileId);
                        if (!deviceProfile.isDefault() && deviceProfileMsg.isDefault()) {
                            this.edgeCtx.getDeviceProfileService().setDefaultDeviceProfile(tenantId, deviceProfileId);
                        }
                        if (removePreviousProfile) {
                            this.updateDevices(tenantId, deviceProfileId, deviceProfileByName.getId());
                            this.edgeCtx.getDeviceProfileService().deleteDeviceProfile(tenantId, deviceProfileByName.getId());
                        }
                        if (!created) return Futures.immediateFuture(null);
                        this.pushDeviceProfileCreatedEventToRuleEngine(tenantId, deviceProfileId);
                        ListenableFuture listenableFuture = this.requestForCalculatedFieldData(tenantId, (EntityId)deviceProfileId);
                        return listenableFuture;
                    }
                    finally {
                        deviceCreationLock.unlock();
                    }
                }
                case 3: {
                    DeviceProfile deviceProfileToDelete = this.edgeCtx.getDeviceProfileService().findDeviceProfileById(tenantId, deviceProfileId);
                    if (deviceProfileToDelete == null) return Futures.immediateFuture(null);
                    this.edgeCtx.getDeviceProfileService().deleteDeviceProfile(tenantId, deviceProfileId);
                    this.pushDeviceProfileDeletedEventToRuleEngine(tenantId, deviceProfileToDelete);
                    return Futures.immediateFuture(null);
                }
                case 4: {
                    ListenableFuture listenableFuture = this.handleUnsupportedMsgType(deviceProfileUpdateMsg.getMsgType());
                    return listenableFuture;
                }
            }
            return Futures.immediateFuture(null);
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    private void pushDeviceProfileCreatedEventToRuleEngine(TenantId tenantId, DeviceProfileId deviceProfileId) {
        DeviceProfile deviceProfile = this.edgeCtx.getDeviceProfileService().findDeviceProfileById(tenantId, deviceProfileId);
        this.pushDeviceProfileEventToRuleEngine(tenantId, deviceProfile, TbMsgType.ENTITY_CREATED);
    }

    private void pushDeviceProfileDeletedEventToRuleEngine(TenantId tenantId, DeviceProfile deviceProfile) {
        this.pushDeviceProfileEventToRuleEngine(tenantId, deviceProfile, TbMsgType.ENTITY_DELETED);
    }

    private void pushDeviceProfileEventToRuleEngine(TenantId tenantId, DeviceProfile deviceProfile, TbMsgType msgType) {
        try {
            String deviceProfileAsString = JacksonUtil.toString((Object)deviceProfile);
            this.pushEntityEventToRuleEngine(tenantId, (EntityId)deviceProfile.getId(), null, msgType, deviceProfileAsString, new TbMsgMetaData());
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push device action to rule engine: {}", new Object[]{tenantId, deviceProfile.getId(), msgType.name(), e});
        }
    }

    private void updateDevices(TenantId tenantId, DeviceProfileId newDeviceProfileId, DeviceProfileId previousDeviceProfileId) {
        PageDataIterable deviceInfosIterable = new PageDataIterable(link -> this.edgeCtx.getDeviceService().findDeviceInfosByFilter(DeviceInfoFilter.builder().tenantId(tenantId).deviceProfileId(previousDeviceProfileId).build(), link), 1024);
        deviceInfosIterable.forEach(deviceInfo -> {
            deviceInfo.setDeviceProfileId(newDeviceProfileId);
            this.edgeCtx.getDeviceService().saveDevice(new Device((Device)deviceInfo));
        });
    }

    private void renameExistingOnEdgeDeviceProfile(DeviceProfile deviceProfileByName) {
        deviceProfileByName.setName(deviceProfileByName.getName() + StringUtils.randomAlphanumeric((int)15));
        this.edgeCtx.getDeviceProfileService().saveDeviceProfile(deviceProfileByName);
    }

    public UplinkMsg convertCloudEventToUplink(CloudEvent cloudEvent) {
        DeviceProfileId deviceProfileId = new DeviceProfileId(cloudEvent.getEntityId());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[cloudEvent.getAction().ordinal()]) {
            case 1: 
            case 2: {
                DeviceProfile deviceProfile = this.edgeCtx.getDeviceProfileService().findDeviceProfileById(cloudEvent.getTenantId(), deviceProfileId);
                if (deviceProfile != null) {
                    UpdateMsgType msgType = this.getUpdateMsgType(cloudEvent.getAction());
                    DeviceProfileUpdateMsg deviceProfileUpdateMsg = EdgeMsgConstructorUtils.constructDeviceProfileUpdatedMsg((UpdateMsgType)msgType, (DeviceProfile)deviceProfile, (EdgeVersion)EdgeVersion.V_LATEST);
                    return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addDeviceProfileUpdateMsg(deviceProfileUpdateMsg).build();
                }
                log.info("Skipping event as device profile was not found [{}]", (Object)cloudEvent);
                break;
            }
            case 3: {
                DeviceProfileUpdateMsg deviceProfileUpdateMsg = EdgeMsgConstructorUtils.constructDeviceProfileDeleteMsg((DeviceProfileId)deviceProfileId);
                return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addDeviceProfileUpdateMsg(deviceProfileUpdateMsg).build();
            }
        }
        return null;
    }

    protected void setDefaultRuleChainId(TenantId tenantId, DeviceProfile deviceProfile, RuleChainId ruleChainId) {
        RuleChainId defaultRuleChainId = deviceProfile.getDefaultEdgeRuleChainId();
        RuleChain ruleChain = null;
        if (defaultRuleChainId != null) {
            ruleChain = this.edgeCtx.getRuleChainService().findRuleChainById(tenantId, defaultRuleChainId);
        }
        deviceProfile.setDefaultRuleChainId(ruleChain != null ? ruleChain.getId() : null);
    }

    protected void setDefaultEdgeRuleChainId(DeviceProfile deviceProfile, RuleChainId ruleChainId, DeviceProfileUpdateMsg deviceProfileUpdateMsg) {
        deviceProfile.setDefaultEdgeRuleChainId(null);
    }

    protected void setDefaultDashboardId(TenantId tenantId, DashboardId dashboardId, DeviceProfile deviceProfile, DeviceProfileUpdateMsg deviceProfileUpdateMsg) {
        DashboardId defaultDashboardId = deviceProfile.getDefaultDashboardId();
        DashboardInfo dashboard = null;
        if (defaultDashboardId != null) {
            dashboard = this.edgeCtx.getDashboardService().findDashboardInfoById(tenantId, defaultDashboardId);
        }
        deviceProfile.setDefaultDashboardId(dashboard != null ? dashboard.getId() : null);
    }

    public CloudEventType getCloudEventType() {
        return CloudEventType.DEVICE_PROFILE;
    }
}

