/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.gen.edge.v1.CustomerUpdateMsg;
import org.thingsboard.server.gen.edge.v1.EdgeConfiguration;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.CustomerCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
@TbCoreComponent
public class CustomerCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomerCloudProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processCustomerMsgFromCloud(TenantId tenantId, CustomerUpdateMsg customerUpdateMsg) throws ThingsboardException {
        CustomerId customerId = new CustomerId(new UUID(customerUpdateMsg.getIdMSB(), customerUpdateMsg.getIdLSB()));
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[customerUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    Customer customer;
                    customerCreationLock.lock();
                    try {
                        customer = (Customer)JacksonUtil.fromString((String)customerUpdateMsg.getEntity(), Customer.class, (boolean)true);
                        if (customer == null) {
                            throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] customerUpdateMsg {" + String.valueOf(customerUpdateMsg) + "} cannot be converted to customer");
                        }
                        EntityId ownerId = customer.getOwnerId();
                        if (EntityType.CUSTOMER.equals((Object)ownerId.getEntityType())) {
                            this.createCustomerIfNotExists(tenantId, new CustomerId(ownerId.getId()));
                        }
                        boolean created = false;
                        CustomerService customerService = this.edgeCtx.getCustomerService();
                        Customer customerById = customerService.findCustomerById(tenantId, customerId);
                        if (customerById == null) {
                            created = true;
                        } else {
                            CustomerId tmpCustomerOwnerId = new CustomerId(EntityId.NULL_UUID);
                            if (EntityType.CUSTOMER.equals((Object)ownerId.getEntityType())) {
                                tmpCustomerOwnerId = new CustomerId(ownerId.getId());
                            }
                            this.changeOwnerIfRequired(tenantId, tmpCustomerOwnerId, (EntityId)customerId);
                        }
                        Optional edgeCustomer = customerService.findCustomerByTenantIdAndTitle(customer.getTenantId(), customer.getTitle());
                        edgeCustomer.filter(oldCustomer -> !oldCustomer.getId().equals((Object)customer.getId())).ifPresent(value -> customerService.deleteCustomer(value.getTenantId(), value.getId()));
                        Customer savedCustomer = customerService.saveCustomer(customer, false);
                        if (created) {
                            this.postCreateSteps(savedCustomer);
                        }
                    }
                    finally {
                        customerCreationLock.unlock();
                    }
                    customer = this.requestForAdditionalData(tenantId, (EntityId)customerId);
                    return customer;
                }
                case 3: {
                    Customer customerById = this.edgeCtx.getCustomerService().findCustomerById(tenantId, customerId);
                    if (customerById != null) {
                        this.edgeCtx.getCustomerService().deleteCustomer(tenantId, customerId);
                    }
                    ListenableFuture listenableFuture = Futures.immediateFuture(null);
                    return listenableFuture;
                }
            }
            ListenableFuture listenableFuture = this.handleUnsupportedMsgType(customerUpdateMsg.getMsgType());
            return listenableFuture;
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    public void createCustomerIfNotExists(TenantId tenantId, EdgeConfiguration edgeConfiguration) {
        CustomerId customerId = this.safeGetCustomerId(edgeConfiguration.getCustomerIdMSB(), edgeConfiguration.getCustomerIdLSB());
        this.createCustomerIfNotExists(tenantId, customerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCustomerIfNotExists(TenantId tenantId, CustomerId customerId) {
        Customer customer = this.edgeCtx.getCustomerService().findCustomerById(tenantId, customerId);
        if (customer == null && customerId != null && !customerId.isNullUid()) {
            customerCreationLock.lock();
            try {
                customer = new Customer();
                customer.setId((UUIDBased)customerId);
                customer.setCreatedTime(Uuids.unixTimestamp((UUID)customerId.getId()));
                customer.setTenantId(tenantId);
                customer.setTitle("TMP_NAME_" + StringUtils.randomAlphanumeric((int)10));
                Customer savedCustomer = this.edgeCtx.getCustomerService().saveCustomer(customer, false);
                this.postCreateSteps(savedCustomer);
            }
            finally {
                customerCreationLock.unlock();
            }
        }
    }

    private void postCreateSteps(Customer savedCustomer) {
        this.edgeCtx.getEntityGroupService().addEntityToEntityGroupAll(savedCustomer.getTenantId(), savedCustomer.getOwnerId(), (EntityId)savedCustomer.getId());
        this.edgeCtx.getEntityGroupService().createEntityGroupAll(savedCustomer.getTenantId(), (EntityId)savedCustomer.getId(), EntityType.CUSTOMER);
        this.edgeCtx.getEntityGroupService().createEntityGroupAll(savedCustomer.getTenantId(), (EntityId)savedCustomer.getId(), EntityType.ASSET);
        this.edgeCtx.getEntityGroupService().createEntityGroupAll(savedCustomer.getTenantId(), (EntityId)savedCustomer.getId(), EntityType.DEVICE);
        this.edgeCtx.getEntityGroupService().createEntityGroupAll(savedCustomer.getTenantId(), (EntityId)savedCustomer.getId(), EntityType.ENTITY_VIEW);
        this.edgeCtx.getEntityGroupService().createEntityGroupAll(savedCustomer.getTenantId(), (EntityId)savedCustomer.getId(), EntityType.EDGE);
        this.edgeCtx.getEntityGroupService().createEntityGroupAll(savedCustomer.getTenantId(), (EntityId)savedCustomer.getId(), EntityType.DASHBOARD);
        this.edgeCtx.getEntityGroupService().createEntityGroupAll(savedCustomer.getTenantId(), (EntityId)savedCustomer.getId(), EntityType.USER);
    }
}

