/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.gen.edge.v1.CalculatedFieldRequestMsg;
import org.thingsboard.server.gen.edge.v1.CalculatedFieldUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.CalculatedFieldCloudProcessor;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.cf.BaseCalculatedFieldProcessor;

@Component
@TbCoreComponent
public class CalculatedFieldCloudProcessor
extends BaseCalculatedFieldProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculatedFieldCloudProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processCalculatedFieldMsgFromCloud(TenantId tenantId, CalculatedFieldUpdateMsg calculatedFieldUpdateMsg) {
        CalculatedFieldId calculatedFieldId = new CalculatedFieldId(new UUID(calculatedFieldUpdateMsg.getIdMSB(), calculatedFieldUpdateMsg.getIdLSB()));
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            ListenableFuture listenableFuture = switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[calculatedFieldUpdateMsg.getMsgType().ordinal()]) {
                case 1, 2 -> {
                    this.saveOrUpdateCalculatedFieldFromCloud(tenantId, calculatedFieldId, calculatedFieldUpdateMsg);
                    yield Futures.immediateFuture(null);
                }
                case 3 -> {
                    CalculatedField calculatedField = this.edgeCtx.getCalculatedFieldService().findById(tenantId, calculatedFieldId);
                    if (calculatedField != null) {
                        this.edgeCtx.getCalculatedFieldService().deleteCalculatedField(tenantId, calculatedFieldId);
                        this.pushCalculatedFieldEventToRuleEngine(tenantId, calculatedField, TbMsgType.ENTITY_DELETED);
                    }
                    yield Futures.immediateFuture(null);
                }
                default -> this.handleUnsupportedMsgType(calculatedFieldUpdateMsg.getMsgType());
            };
            return listenableFuture;
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    private void saveOrUpdateCalculatedFieldFromCloud(TenantId tenantId, CalculatedFieldId calculatedFieldId, CalculatedFieldUpdateMsg calculatedFieldUpdateMsg) {
        Boolean calculatedFieldNameWasUpdated;
        Pair resultPair = super.saveOrUpdateCalculatedField(tenantId, calculatedFieldId, calculatedFieldUpdateMsg);
        Boolean wasCreated = (Boolean)resultPair.getFirst();
        if (wasCreated.booleanValue()) {
            CalculatedField calculatedField = this.edgeCtx.getCalculatedFieldService().findById(tenantId, calculatedFieldId);
            this.pushCalculatedFieldEventToRuleEngine(tenantId, calculatedField, TbMsgType.ENTITY_CREATED);
        }
        if ((calculatedFieldNameWasUpdated = (Boolean)resultPair.getSecond()).booleanValue()) {
            this.cloudEventService.saveCloudEventAsync(tenantId, CloudEventType.CALCULATED_FIELD, EdgeEventActionType.UPDATED, (EntityId)calculatedFieldId, null, null);
        }
    }

    private void pushCalculatedFieldEventToRuleEngine(TenantId tenantId, CalculatedField calculatedField, TbMsgType msgType) {
        try {
            String calculatedFieldAsString = JacksonUtil.toString((Object)calculatedField);
            this.pushEntityEventToRuleEngine(tenantId, (EntityId)calculatedField.getId(), null, msgType, calculatedFieldAsString, new TbMsgMetaData());
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push calculatedField action to rule engine: {}", new Object[]{tenantId, calculatedField.getId(), msgType.name(), e});
        }
    }

    public UplinkMsg convertCloudEventToUplink(CloudEvent cloudEvent) {
        CalculatedFieldId calculatedFieldId = new CalculatedFieldId(cloudEvent.getEntityId());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[cloudEvent.getAction().ordinal()]) {
            case 1: 
            case 2: {
                CalculatedField calculatedField = this.edgeCtx.getCalculatedFieldService().findById(cloudEvent.getTenantId(), calculatedFieldId);
                if (calculatedField != null) {
                    UpdateMsgType msgType = this.getUpdateMsgType(cloudEvent.getAction());
                    CalculatedFieldUpdateMsg calculatedFieldUpdateMsg = EdgeMsgConstructorUtils.constructCalculatedFieldUpdatedMsg((UpdateMsgType)msgType, (CalculatedField)calculatedField);
                    UplinkMsg.Builder builder = UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addCalculatedFieldUpdateMsg(calculatedFieldUpdateMsg);
                    return builder.build();
                }
                log.info("Skipping event as calculatedField was not found [{}]", (Object)cloudEvent);
                break;
            }
            case 3: {
                CalculatedFieldUpdateMsg calculatedFieldUpdateMsg = EdgeMsgConstructorUtils.constructCalculatedFieldDeleteMsg((CalculatedFieldId)calculatedFieldId);
                return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addCalculatedFieldUpdateMsg(calculatedFieldUpdateMsg).build();
            }
        }
        return null;
    }

    public UplinkMsg convertCalculatedFieldRequestEventToUplink(CloudEvent cloudEvent) {
        EntityId entityId = EntityIdFactory.getByCloudEventTypeAndUuid((CloudEventType)cloudEvent.getType(), (UUID)cloudEvent.getEntityId());
        CalculatedFieldRequestMsg calculatedFieldRequestMsg = CalculatedFieldRequestMsg.newBuilder().setEntityIdMSB(entityId.getId().getMostSignificantBits()).setEntityIdLSB(entityId.getId().getLeastSignificantBits()).setEntityType(entityId.getEntityType().name()).build();
        UplinkMsg.Builder builder = UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addCalculatedFieldRequestMsg(calculatedFieldRequestMsg);
        return builder.build();
    }

    public CloudEventType getCloudEventType() {
        return CloudEventType.CALCULATED_FIELD;
    }
}

