/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.DashboardInfo;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.gen.edge.v1.AssetProfileUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.AssetProfileCloudProcessor;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.asset.profile.BaseAssetProfileProcessor;

@Component
@TbCoreComponent
public class AssetProfileCloudProcessor
extends BaseAssetProfileProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetProfileCloudProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListenableFuture<Void> processAssetProfileMsgFromCloud(TenantId tenantId, AssetProfileUpdateMsg assetProfileUpdateMsg) {
        AssetProfileId assetProfileId = new AssetProfileId(new UUID(assetProfileUpdateMsg.getIdMSB(), assetProfileUpdateMsg.getIdLSB()));
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[assetProfileUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    assetCreationLock.lock();
                    try {
                        AssetProfile assetProfileMsg = (AssetProfile)JacksonUtil.fromString((String)assetProfileUpdateMsg.getEntity(), AssetProfile.class, (boolean)true);
                        if (assetProfileMsg == null) {
                            throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] assetProfileUpdateMsg {" + String.valueOf(assetProfileUpdateMsg) + "} cannot be converted to asset profile");
                        }
                        AssetProfile assetProfileByName = this.edgeCtx.getAssetProfileService().findAssetProfileByName(tenantId, assetProfileMsg.getName());
                        boolean removePreviousProfile = false;
                        if (assetProfileByName != null && !assetProfileByName.getId().equals((Object)assetProfileId)) {
                            this.renamePreviousAssetProfile(assetProfileByName);
                            removePreviousProfile = true;
                        }
                        Pair resultPair = super.saveOrUpdateAssetProfile(tenantId, assetProfileId, assetProfileUpdateMsg);
                        boolean created = (Boolean)resultPair.getFirst();
                        AssetProfile assetProfile = this.edgeCtx.getAssetProfileService().findAssetProfileById(tenantId, assetProfileId);
                        if (!assetProfile.isDefault() && assetProfileMsg.isDefault()) {
                            this.edgeCtx.getAssetProfileService().setDefaultAssetProfile(tenantId, assetProfileId);
                        }
                        if (removePreviousProfile) {
                            this.updateAssets(tenantId, assetProfileId, assetProfileByName.getId());
                            this.edgeCtx.getAssetProfileService().deleteAssetProfile(tenantId, assetProfileByName.getId());
                        }
                        if (!created) return Futures.immediateFuture(null);
                        this.pushAssetProfileCreatedEventToRuleEngine(tenantId, assetProfileId);
                        ListenableFuture listenableFuture = this.requestForCalculatedFieldData(tenantId, (EntityId)assetProfileId);
                        return listenableFuture;
                    }
                    finally {
                        assetCreationLock.unlock();
                    }
                }
                case 3: {
                    AssetProfile assetProfile = this.edgeCtx.getAssetProfileService().findAssetProfileById(tenantId, assetProfileId);
                    if (assetProfile == null) return Futures.immediateFuture(null);
                    this.edgeCtx.getAssetProfileService().deleteAssetProfile(tenantId, assetProfileId);
                    this.pushAssetProfileDeletedEventToRuleEngine(tenantId, assetProfile);
                    return Futures.immediateFuture(null);
                }
                case 4: {
                    ListenableFuture listenableFuture = this.handleUnsupportedMsgType(assetProfileUpdateMsg.getMsgType());
                    return listenableFuture;
                }
            }
            return Futures.immediateFuture(null);
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    private void pushAssetProfileCreatedEventToRuleEngine(TenantId tenantId, AssetProfileId assetProfileId) {
        AssetProfile assetProfile = this.edgeCtx.getAssetProfileService().findAssetProfileById(tenantId, assetProfileId);
        this.pushAssetProfileEventToRuleEngine(tenantId, assetProfile, TbMsgType.ENTITY_CREATED);
    }

    private void pushAssetProfileDeletedEventToRuleEngine(TenantId tenantId, AssetProfile assetProfile) {
        this.pushAssetProfileEventToRuleEngine(tenantId, assetProfile, TbMsgType.ENTITY_DELETED);
    }

    private void pushAssetProfileEventToRuleEngine(TenantId tenantId, AssetProfile assetProfile, TbMsgType msgType) {
        try {
            String assetProfileAsString = JacksonUtil.toString((Object)assetProfile);
            this.pushEntityEventToRuleEngine(tenantId, (EntityId)assetProfile.getId(), null, msgType, assetProfileAsString, new TbMsgMetaData());
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push asset profile action to rule engine: {}", new Object[]{tenantId, assetProfile.getId(), msgType.name(), e});
        }
    }

    private void renamePreviousAssetProfile(AssetProfile assetProfileByName) {
        assetProfileByName.setName(assetProfileByName.getName() + StringUtils.randomAlphanumeric((int)15));
        this.edgeCtx.getAssetProfileService().saveAssetProfile(assetProfileByName);
    }

    private void updateAssets(TenantId tenantId, AssetProfileId newAssetProfileId, AssetProfileId previousAssetProfileId) {
        PageDataIterable assetInfosIterable = new PageDataIterable(link -> this.edgeCtx.getAssetService().findAssetInfosByTenantIdAndAssetProfileId(tenantId, previousAssetProfileId, link), 1024);
        assetInfosIterable.forEach(assetInfo -> {
            assetInfo.setAssetProfileId(newAssetProfileId);
            this.edgeCtx.getAssetService().saveAsset(new Asset((Asset)assetInfo));
        });
    }

    public UplinkMsg convertCloudEventToUplink(CloudEvent cloudEvent) {
        AssetProfileId assetProfileId = new AssetProfileId(cloudEvent.getEntityId());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[cloudEvent.getAction().ordinal()]) {
            case 1: 
            case 2: {
                AssetProfile assetProfile = this.edgeCtx.getAssetProfileService().findAssetProfileById(cloudEvent.getTenantId(), assetProfileId);
                if (assetProfile != null && !"TbServiceQueue".equals(assetProfile.getName())) {
                    UpdateMsgType msgType = this.getUpdateMsgType(cloudEvent.getAction());
                    AssetProfileUpdateMsg assetProfileUpdateMsg = EdgeMsgConstructorUtils.constructAssetProfileUpdatedMsg((UpdateMsgType)msgType, (AssetProfile)assetProfile);
                    return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addAssetProfileUpdateMsg(assetProfileUpdateMsg).build();
                }
                log.info("Skipping event as asset profile was not found [{}]", (Object)cloudEvent);
                break;
            }
            case 3: {
                AssetProfileUpdateMsg assetProfileUpdateMsg = EdgeMsgConstructorUtils.constructAssetProfileDeleteMsg((AssetProfileId)assetProfileId);
                return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addAssetProfileUpdateMsg(assetProfileUpdateMsg).build();
            }
        }
        return null;
    }

    protected void setDefaultRuleChainId(TenantId tenantId, AssetProfile assetProfile, RuleChainId ruleChainId) {
        RuleChainId defaultRuleChainId = assetProfile.getDefaultEdgeRuleChainId();
        RuleChain ruleChain = null;
        if (defaultRuleChainId != null) {
            ruleChain = this.edgeCtx.getRuleChainService().findRuleChainById(tenantId, defaultRuleChainId);
        }
        assetProfile.setDefaultRuleChainId(ruleChain != null ? ruleChain.getId() : null);
    }

    protected void setDefaultEdgeRuleChainId(AssetProfile assetProfile, RuleChainId ruleChainId, AssetProfileUpdateMsg assetProfileUpdateMsg) {
        assetProfile.setDefaultEdgeRuleChainId(null);
    }

    protected void setDefaultDashboardId(TenantId tenantId, DashboardId dashboardId, AssetProfile assetProfile, AssetProfileUpdateMsg assetProfileUpdateMsg) {
        DashboardId defaultDashboardId = assetProfile.getDefaultDashboardId();
        DashboardInfo dashboard = null;
        if (defaultDashboardId != null) {
            dashboard = this.edgeCtx.getDashboardService().findDashboardInfoById(tenantId, defaultDashboardId);
        }
        assetProfile.setDefaultDashboardId(dashboard != null ? dashboard.getId() : null);
    }

    public CloudEventType getCloudEventType() {
        return CloudEventType.ASSET_PROFILE;
    }
}

