/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.subscription.SubscriptionException;
import org.thingsboard.server.gen.edge.v1.AssetUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.AssetCloudProcessor;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.asset.BaseAssetProcessor;

@Component
@TbCoreComponent
public class AssetCloudProcessor
extends BaseAssetProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetCloudProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processAssetMsgFromCloud(TenantId tenantId, AssetUpdateMsg assetUpdateMsg) throws ThingsboardException {
        AssetId assetId = new AssetId(new UUID(assetUpdateMsg.getIdMSB(), assetUpdateMsg.getIdLSB()));
        try {
            ListenableFuture listenableFuture;
            ListenableFuture listenableFuture2;
            this.cloudSynchronizationManager.getSync().set(true);
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[assetUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    Pair limitReachedCreated = this.saveOrUpdateAssetFromCloud(tenantId, assetId, assetUpdateMsg);
                    boolean limitReached = (Boolean)limitReachedCreated.getFirst();
                    if (limitReached) {
                        listenableFuture = listenableFuture2 = Futures.immediateFuture(null);
                        break;
                    }
                    boolean created = (Boolean)limitReachedCreated.getSecond();
                    if (created) {
                        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
                        futures.add(this.requestForAdditionalData(tenantId, (EntityId)assetId));
                        futures.add(this.requestForCalculatedFieldData(tenantId, (EntityId)assetId));
                        listenableFuture = listenableFuture2 = Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)this.dbCallbackExecutorService);
                        break;
                    }
                    listenableFuture = listenableFuture2 = Futures.immediateFuture(null);
                    break;
                }
                case 3: {
                    assetCreationLock.lock();
                    if (assetUpdateMsg.hasEntityGroupIdMSB() && assetUpdateMsg.hasEntityGroupIdLSB()) {
                        UUID entityGroupUUID = this.safeGetUUID(assetUpdateMsg.getEntityGroupIdMSB(), assetUpdateMsg.getEntityGroupIdLSB());
                        EntityGroupId entityGroupId = new EntityGroupId(entityGroupUUID);
                        this.edgeCtx.getEntityGroupService().removeEntityFromEntityGroup(tenantId, entityGroupId, (EntityId)assetId);
                        listenableFuture2 = this.removeEntityIfInSingleAllGroup(tenantId, (EntityId)assetId, () -> this.edgeCtx.getAssetService().deleteAsset(tenantId, assetId));
                        listenableFuture = listenableFuture2;
                        break;
                    }
                    this.deleteAsset(tenantId, assetId);
                    listenableFuture2 = Futures.immediateFuture(null);
                    listenableFuture = listenableFuture2;
                    break;
                    finally {
                        assetCreationLock.unlock();
                    }
                }
                default: {
                    listenableFuture = listenableFuture2 = this.handleUnsupportedMsgType(assetUpdateMsg.getMsgType());
                }
            }
            listenableFuture2 = listenableFuture;
            return listenableFuture2;
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    private Pair<Boolean, Boolean> saveOrUpdateAssetFromCloud(TenantId tenantId, AssetId assetId, AssetUpdateMsg assetUpdateMsg) throws ThingsboardException {
        boolean created;
        try {
            Boolean assetNameUpdated;
            Pair resultPair = super.saveOrUpdateAsset(tenantId, assetId, assetUpdateMsg);
            created = (Boolean)resultPair.getFirst();
            if (created) {
                this.pushAssetCreatedEventToRuleEngine(tenantId, assetId);
            }
            if ((assetNameUpdated = (Boolean)resultPair.getSecond()).booleanValue()) {
                this.cloudEventService.saveCloudEventAsync(tenantId, CloudEventType.ASSET, EdgeEventActionType.UPDATED, (EntityId)assetId, null, null);
            }
        }
        catch (SubscriptionException e) {
            log.error("[{}][{}] Subscription error occurred for msg {}", new Object[]{tenantId, assetId, assetUpdateMsg, e});
            if (e.getMessage().contains("limit reached")) {
                return Pair.of((Object)true, (Object)false);
            }
            throw e;
        }
        return Pair.of((Object)false, (Object)created);
    }

    private void pushAssetCreatedEventToRuleEngine(TenantId tenantId, AssetId assetId) {
        Asset asset = this.edgeCtx.getAssetService().findAssetById(tenantId, assetId);
        this.pushEntityEventToRuleEngine(tenantId, (HasId)asset, TbMsgType.ENTITY_CREATED);
    }

    public UplinkMsg convertCloudEventToUplink(CloudEvent cloudEvent) {
        AssetId assetId = new AssetId(cloudEvent.getEntityId());
        EntityGroupId entityGroupId = cloudEvent.getEntityGroupId() != null ? new EntityGroupId(cloudEvent.getEntityGroupId()) : null;
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[cloudEvent.getAction().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                Asset asset = this.edgeCtx.getAssetService().findAssetById(cloudEvent.getTenantId(), assetId);
                if (asset != null) {
                    if ("TbServiceQueue".equals(asset.getType())) {
                        log.debug("Skipping TbServiceQueue asset [{}]", (Object)cloudEvent);
                        break;
                    }
                    UpdateMsgType msgType = this.getUpdateMsgType(cloudEvent.getAction());
                    AssetUpdateMsg assetUpdateMsg = EdgeMsgConstructorUtils.constructAssetUpdatedMsg((UpdateMsgType)msgType, (Asset)asset, (EntityGroupId)entityGroupId);
                    UplinkMsg.Builder builder = UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addAssetUpdateMsg(assetUpdateMsg);
                    if (UpdateMsgType.ENTITY_CREATED_RPC_MESSAGE.equals((Object)msgType)) {
                        AssetProfile assetProfile = this.edgeCtx.getAssetProfileService().findAssetProfileById(cloudEvent.getTenantId(), asset.getAssetProfileId());
                        builder.addAssetProfileUpdateMsg(EdgeMsgConstructorUtils.constructAssetProfileUpdatedMsg((UpdateMsgType)msgType, (AssetProfile)assetProfile));
                    }
                    return builder.build();
                }
                log.debug("Skipping event as asset was not found [{}]", (Object)cloudEvent);
                break;
            }
            case 4: 
            case 5: {
                AssetUpdateMsg assetUpdateMsg = EdgeMsgConstructorUtils.constructAssetDeleteMsg((AssetId)assetId, (EntityGroupId)entityGroupId);
                return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addAssetUpdateMsg(assetUpdateMsg).build();
            }
        }
        return null;
    }

    protected void setCustomerId(TenantId tenantId, CustomerId customerId, Asset asset, AssetUpdateMsg assetUpdateMsg) {
        CustomerId assignedCustomerId = asset.getCustomerId();
        Customer customer = null;
        if (assignedCustomerId != null) {
            customer = this.edgeCtx.getCustomerService().findCustomerById(tenantId, assignedCustomerId);
        }
        asset.setCustomerId(customer != null ? customer.getId() : null);
    }

    public CloudEventType getCloudEventType() {
        return CloudEventType.ASSET;
    }
}

