/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.ListenableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.alarm.AlarmComment;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.gen.edge.v1.AlarmCommentUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.AlarmCommentCloudProcessor;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.alarm.BaseAlarmProcessor;

@Component
@TbCoreComponent
public class AlarmCommentCloudProcessor
extends BaseAlarmProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlarmCommentCloudProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processAlarmCommentMsgFromCloud(TenantId tenantId, AlarmCommentUpdateMsg alarmCommentUpdateMsg) {
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            ListenableFuture listenableFuture = this.processAlarmCommentMsg(tenantId, alarmCommentUpdateMsg);
            return listenableFuture;
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    public UplinkMsg convertCloudEventToUplink(CloudEvent cloudEvent) {
        UpdateMsgType msgType = this.getUpdateMsgType(cloudEvent.getAction());
        return switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[cloudEvent.getAction().ordinal()]) {
            case 1, 2, 3 -> {
                AlarmComment alarmComment = (AlarmComment)JacksonUtil.convertValue((Object)cloudEvent.getEntityBody(), AlarmComment.class);
                yield UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addAlarmCommentUpdateMsg(EdgeMsgConstructorUtils.constructAlarmCommentUpdatedMsg((UpdateMsgType)msgType, (AlarmComment)alarmComment)).build();
            }
            default -> null;
        };
    }

    public CloudEventType getCloudEventType() {
        return CloudEventType.ALARM_COMMENT;
    }
}

