/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc;

import com.google.common.util.concurrent.FutureCallback;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.rule.engine.api.AttributesSaveRequest;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.service.cloud.info.EdgeInfoHolder;
import org.thingsboard.server.service.cloud.rpc.ConnectionStatusManager;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;

@Service
public class ConnectionStatusManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectionStatusManager.class);
    private final TelemetrySubscriptionService tsSubService;
    private final EdgeInfoHolder edgeInfoHolder;

    public void updateConnectivityStatus(boolean activityState) {
        TenantId tenantId = this.edgeInfoHolder.getTenantId();
        if (tenantId != null) {
            this.save(tenantId, "active", activityState);
            if (activityState) {
                this.save(tenantId, "lastConnectTime", System.currentTimeMillis());
            } else {
                this.save(tenantId, "lastDisconnectTime", System.currentTimeMillis());
            }
        }
    }

    private void save(TenantId tenantId, String key, long value) {
        this.tsSubService.saveAttributes(AttributesSaveRequest.builder().tenantId(TenantId.SYS_TENANT_ID).entityId((EntityId)tenantId).scope(AttributeScope.SERVER_SCOPE).entry((KvEntry)new LongDataEntry(key, Long.valueOf(value))).notifyDevice(true).callback((FutureCallback)new AttributeSaveCallback(key, (Object)value)).build());
    }

    private void save(TenantId tenantId, String key, boolean value) {
        this.tsSubService.saveAttributes(AttributesSaveRequest.builder().tenantId(TenantId.SYS_TENANT_ID).entityId((EntityId)tenantId).scope(AttributeScope.SERVER_SCOPE).entry((KvEntry)new BooleanDataEntry(key, Boolean.valueOf(value))).notifyDevice(true).callback((FutureCallback)new AttributeSaveCallback(key, (Object)value)).build());
    }

    @ConstructorProperties(value={"tsSubService", "edgeInfoHolder"})
    @Generated
    public ConnectionStatusManager(TelemetrySubscriptionService tsSubService, EdgeInfoHolder edgeInfoHolder) {
        this.tsSubService = tsSubService;
        this.edgeInfoHolder = edgeInfoHolder;
    }
}

