/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.info;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;

@Component
public class PendingUplinkMsgPackHolder {
    @Value(value="${cloud.uplink_pack_timeout_sec:60}")
    private long uplinkPackTimeoutSec;
    private final ConcurrentMap<Integer, UplinkMsg> pendingMsgMap = new ConcurrentHashMap();
    private CountDownLatch latch;

    public void markAsProcessed(Integer uplinkMsgId) {
        this.pendingMsgMap.remove(uplinkMsgId);
        this.latch.countDown();
    }

    public void countDown() {
        this.latch.countDown();
    }

    public boolean awaitBatchCompletion() throws InterruptedException {
        return this.latch.await(this.uplinkPackTimeoutSec, TimeUnit.SECONDS);
    }

    public void startPendingBatch() {
        this.latch = new CountDownLatch(this.pendingMsgMap.size());
    }

    public LinkedBlockingQueue<UplinkMsg> getQueue() {
        return new LinkedBlockingQueue<UplinkMsg>(this.getValues());
    }

    public Collection<UplinkMsg> getValues() {
        return this.pendingMsgMap.values();
    }

    public void setNewPack(List<UplinkMsg> uplinkMsgPack) {
        this.pendingMsgMap.clear();
        uplinkMsgPack.forEach(msg -> this.pendingMsgMap.put(msg.getUplinkMsgId(), msg));
    }

    public void clear() {
        this.pendingMsgMap.clear();
    }

    public int getQueueSize() {
        return this.pendingMsgMap.size();
    }

    public boolean isQueueEmpty() {
        return this.pendingMsgMap.isEmpty();
    }

    @Generated
    public long getUplinkPackTimeoutSec() {
        return this.uplinkPackTimeoutSec;
    }

    @Generated
    public ConcurrentMap<Integer, UplinkMsg> getPendingMsgMap() {
        return this.pendingMsgMap;
    }

    @Generated
    public CountDownLatch getLatch() {
        return this.latch;
    }

    @Generated
    public void setUplinkPackTimeoutSec(long uplinkPackTimeoutSec) {
        this.uplinkPackTimeoutSec = uplinkPackTimeoutSec;
    }

    @Generated
    public void setLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PendingUplinkMsgPackHolder)) {
            return false;
        }
        PendingUplinkMsgPackHolder other = (PendingUplinkMsgPackHolder)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getUplinkPackTimeoutSec() != other.getUplinkPackTimeoutSec()) {
            return false;
        }
        ConcurrentMap this$pendingMsgMap = this.getPendingMsgMap();
        ConcurrentMap other$pendingMsgMap = other.getPendingMsgMap();
        if (this$pendingMsgMap == null ? other$pendingMsgMap != null : !this$pendingMsgMap.equals(other$pendingMsgMap)) {
            return false;
        }
        CountDownLatch this$latch = this.getLatch();
        CountDownLatch other$latch = other.getLatch();
        return !(this$latch == null ? other$latch != null : !this$latch.equals(other$latch));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PendingUplinkMsgPackHolder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $uplinkPackTimeoutSec = this.getUplinkPackTimeoutSec();
        result = result * 59 + (int)($uplinkPackTimeoutSec >>> 32 ^ $uplinkPackTimeoutSec);
        ConcurrentMap $pendingMsgMap = this.getPendingMsgMap();
        result = result * 59 + ($pendingMsgMap == null ? 43 : $pendingMsgMap.hashCode());
        CountDownLatch $latch = this.getLatch();
        result = result * 59 + ($latch == null ? 43 : $latch.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PendingUplinkMsgPackHolder(uplinkPackTimeoutSec=" + this.getUplinkPackTimeoutSec() + ", pendingMsgMap=" + String.valueOf(this.getPendingMsgMap()) + ", latch=" + String.valueOf(this.getLatch()) + ")";
    }
}

