/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.info;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.edge.EdgeSettings;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;

@Component
public class EdgeInfoHolder {
    @Value(value="${cloud.routingKey}")
    private String routingKey;
    @Value(value="${cloud.secret}")
    private String routingSecret;
    @Value(value="${cloud.reconnect_timeout}")
    private long reconnectTimeoutMs;
    @Value(value="${cloud.rpc.host}")
    private String rpcHost;
    private TenantId tenantId;
    private CustomerId customerId;
    private EdgeSettings settings;
    private volatile boolean generalProcessInProgress;
    private volatile boolean initialized;
    private volatile boolean offlineInitialized;
    private volatile boolean initInProgress;
    private volatile boolean syncInProgress;
    private volatile boolean sendingInProgress;
    private AtomicBoolean isRateLimitViolated = new AtomicBoolean(false);
    private volatile boolean performInitialSyncRequired = true;
    private final Lock uplinkSendLock = new ReentrantLock();

    public void resetProcessingFlags() {
        this.generalProcessInProgress = false;
        this.initialized = false;
        this.initInProgress = false;
        this.syncInProgress = false;
        this.sendingInProgress = false;
    }

    public void lockSend() {
        this.uplinkSendLock.lock();
    }

    public void unlockSend() {
        this.uplinkSendLock.unlock();
    }

    public void setRateLimitViolated(boolean rateLimitViolated) {
        this.isRateLimitViolated.set(rateLimitViolated);
    }

    public boolean clearRateLimitViolationIfSet() {
        return this.isRateLimitViolated.compareAndSet(true, false);
    }

    @Generated
    public String getRoutingKey() {
        return this.routingKey;
    }

    @Generated
    public String getRoutingSecret() {
        return this.routingSecret;
    }

    @Generated
    public long getReconnectTimeoutMs() {
        return this.reconnectTimeoutMs;
    }

    @Generated
    public String getRpcHost() {
        return this.rpcHost;
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @Generated
    public EdgeSettings getSettings() {
        return this.settings;
    }

    @Generated
    public boolean isGeneralProcessInProgress() {
        return this.generalProcessInProgress;
    }

    @Generated
    public boolean isInitialized() {
        return this.initialized;
    }

    @Generated
    public boolean isOfflineInitialized() {
        return this.offlineInitialized;
    }

    @Generated
    public boolean isInitInProgress() {
        return this.initInProgress;
    }

    @Generated
    public boolean isSyncInProgress() {
        return this.syncInProgress;
    }

    @Generated
    public boolean isSendingInProgress() {
        return this.sendingInProgress;
    }

    @Generated
    public AtomicBoolean getIsRateLimitViolated() {
        return this.isRateLimitViolated;
    }

    @Generated
    public boolean isPerformInitialSyncRequired() {
        return this.performInitialSyncRequired;
    }

    @Generated
    public Lock getUplinkSendLock() {
        return this.uplinkSendLock;
    }

    @Generated
    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    @Generated
    public void setRoutingSecret(String routingSecret) {
        this.routingSecret = routingSecret;
    }

    @Generated
    public void setReconnectTimeoutMs(long reconnectTimeoutMs) {
        this.reconnectTimeoutMs = reconnectTimeoutMs;
    }

    @Generated
    public void setRpcHost(String rpcHost) {
        this.rpcHost = rpcHost;
    }

    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setSettings(EdgeSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setGeneralProcessInProgress(boolean generalProcessInProgress) {
        this.generalProcessInProgress = generalProcessInProgress;
    }

    @Generated
    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Generated
    public void setOfflineInitialized(boolean offlineInitialized) {
        this.offlineInitialized = offlineInitialized;
    }

    @Generated
    public void setInitInProgress(boolean initInProgress) {
        this.initInProgress = initInProgress;
    }

    @Generated
    public void setSyncInProgress(boolean syncInProgress) {
        this.syncInProgress = syncInProgress;
    }

    @Generated
    public void setSendingInProgress(boolean sendingInProgress) {
        this.sendingInProgress = sendingInProgress;
    }

    @Generated
    public void setIsRateLimitViolated(AtomicBoolean isRateLimitViolated) {
        this.isRateLimitViolated = isRateLimitViolated;
    }

    @Generated
    public void setPerformInitialSyncRequired(boolean performInitialSyncRequired) {
        this.performInitialSyncRequired = performInitialSyncRequired;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EdgeInfoHolder)) {
            return false;
        }
        EdgeInfoHolder other = (EdgeInfoHolder)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getReconnectTimeoutMs() != other.getReconnectTimeoutMs()) {
            return false;
        }
        if (this.isGeneralProcessInProgress() != other.isGeneralProcessInProgress()) {
            return false;
        }
        if (this.isInitialized() != other.isInitialized()) {
            return false;
        }
        if (this.isOfflineInitialized() != other.isOfflineInitialized()) {
            return false;
        }
        if (this.isInitInProgress() != other.isInitInProgress()) {
            return false;
        }
        if (this.isSyncInProgress() != other.isSyncInProgress()) {
            return false;
        }
        if (this.isSendingInProgress() != other.isSendingInProgress()) {
            return false;
        }
        if (this.isPerformInitialSyncRequired() != other.isPerformInitialSyncRequired()) {
            return false;
        }
        String this$routingKey = this.getRoutingKey();
        String other$routingKey = other.getRoutingKey();
        if (this$routingKey == null ? other$routingKey != null : !this$routingKey.equals(other$routingKey)) {
            return false;
        }
        String this$routingSecret = this.getRoutingSecret();
        String other$routingSecret = other.getRoutingSecret();
        if (this$routingSecret == null ? other$routingSecret != null : !this$routingSecret.equals(other$routingSecret)) {
            return false;
        }
        String this$rpcHost = this.getRpcHost();
        String other$rpcHost = other.getRpcHost();
        if (this$rpcHost == null ? other$rpcHost != null : !this$rpcHost.equals(other$rpcHost)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !this$customerId.equals(other$customerId)) {
            return false;
        }
        EdgeSettings this$settings = this.getSettings();
        EdgeSettings other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !this$settings.equals(other$settings)) {
            return false;
        }
        AtomicBoolean this$isRateLimitViolated = this.getIsRateLimitViolated();
        AtomicBoolean other$isRateLimitViolated = other.getIsRateLimitViolated();
        if (this$isRateLimitViolated == null ? other$isRateLimitViolated != null : !this$isRateLimitViolated.equals(other$isRateLimitViolated)) {
            return false;
        }
        Lock this$uplinkSendLock = this.getUplinkSendLock();
        Lock other$uplinkSendLock = other.getUplinkSendLock();
        return !(this$uplinkSendLock == null ? other$uplinkSendLock != null : !this$uplinkSendLock.equals(other$uplinkSendLock));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EdgeInfoHolder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $reconnectTimeoutMs = this.getReconnectTimeoutMs();
        result = result * 59 + (int)($reconnectTimeoutMs >>> 32 ^ $reconnectTimeoutMs);
        result = result * 59 + (this.isGeneralProcessInProgress() ? 79 : 97);
        result = result * 59 + (this.isInitialized() ? 79 : 97);
        result = result * 59 + (this.isOfflineInitialized() ? 79 : 97);
        result = result * 59 + (this.isInitInProgress() ? 79 : 97);
        result = result * 59 + (this.isSyncInProgress() ? 79 : 97);
        result = result * 59 + (this.isSendingInProgress() ? 79 : 97);
        result = result * 59 + (this.isPerformInitialSyncRequired() ? 79 : 97);
        String $routingKey = this.getRoutingKey();
        result = result * 59 + ($routingKey == null ? 43 : $routingKey.hashCode());
        String $routingSecret = this.getRoutingSecret();
        result = result * 59 + ($routingSecret == null ? 43 : $routingSecret.hashCode());
        String $rpcHost = this.getRpcHost();
        result = result * 59 + ($rpcHost == null ? 43 : $rpcHost.hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : $customerId.hashCode());
        EdgeSettings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : $settings.hashCode());
        AtomicBoolean $isRateLimitViolated = this.getIsRateLimitViolated();
        result = result * 59 + ($isRateLimitViolated == null ? 43 : $isRateLimitViolated.hashCode());
        Lock $uplinkSendLock = this.getUplinkSendLock();
        result = result * 59 + ($uplinkSendLock == null ? 43 : $uplinkSendLock.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EdgeInfoHolder(routingKey=" + this.getRoutingKey() + ", routingSecret=" + this.getRoutingSecret() + ", reconnectTimeoutMs=" + this.getReconnectTimeoutMs() + ", rpcHost=" + this.getRpcHost() + ", tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", settings=" + String.valueOf(this.getSettings()) + ", generalProcessInProgress=" + this.isGeneralProcessInProgress() + ", initialized=" + this.isInitialized() + ", offlineInitialized=" + this.isOfflineInitialized() + ", initInProgress=" + this.isInitInProgress() + ", syncInProgress=" + this.isSyncInProgress() + ", sendingInProgress=" + this.isSendingInProgress() + ", isRateLimitViolated=" + String.valueOf(this.getIsRateLimitViolated()) + ", performInitialSyncRequired=" + this.isPerformInitialSyncRequired() + ", uplinkSendLock=" + String.valueOf(this.getUplinkSendLock()) + ")";
    }
}

