/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.event.sender;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.dao.cloud.CloudEventService;
import org.thingsboard.server.service.cloud.event.sender.CloudEventUplinkSender;

@Service
public class KafkaCloudEventUplinkSender
implements CloudEventUplinkSender {
    private final CloudEventService kafkaEventService;

    public ListenableFuture<Boolean> sendCloudEvents(List<CloudEvent> cloudEvents, boolean isGeneralMsg) {
        for (CloudEvent cloudEvent : cloudEvents) {
            if (isGeneralMsg) {
                this.kafkaEventService.saveAsync(cloudEvent);
                continue;
            }
            this.kafkaEventService.saveTsKvAsync(cloudEvent);
        }
        return Futures.immediateFuture((Object)Boolean.FALSE);
    }

    public void init() {
    }

    public void shutdown() {
    }

    @ConstructorProperties(value={"kafkaEventService"})
    @Generated
    public KafkaCloudEventUplinkSender(CloudEventService kafkaEventService) {
        this.kafkaEventService = kafkaEventService;
    }
}

