/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.event.runner;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.cloud.CloudEventService;
import org.thingsboard.server.service.cloud.CloudEventFinder;
import org.thingsboard.server.service.cloud.event.postgres.BasePostgresCloudEventUplinkBatchDispatcher;
import org.thingsboard.server.service.cloud.event.postgres.PostgresCloudEventUplinkRetriever;
import org.thingsboard.server.service.cloud.event.runner.CloudEventUplinkProcessingRunner;
import org.thingsboard.server.service.cloud.info.EdgeInfoHolder;
import org.thingsboard.server.service.cloud.rpc.CloudEventStorageSettings;
import org.thingsboard.server.service.executors.DbCallbackExecutorService;

@Service
@ConditionalOnExpression(value="'${queue.type:null}'!='kafka'")
public class PostgresCloudEventUplinkProcessingRunner
implements CloudEventUplinkProcessingRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostgresCloudEventUplinkProcessingRunner.class);
    private final BasePostgresCloudEventUplinkBatchDispatcher cloudEventUplinkBatchDispatcher;
    private final PostgresCloudEventUplinkRetriever cloudEventUplinkRetriever;
    private final DbCallbackExecutorService dbCallbackExecutorService;
    private final CloudEventStorageSettings cloudEventStorageSettings;
    private final CloudEventService cloudEventService;
    private final AttributesService attributesService;
    private final EdgeInfoHolder edgeInfo;
    private ExecutorService executor;
    private ExecutorService tsExecutor;

    public void init() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"postgres-cloud-manager"));
            this.executor.submit(() -> this.launchUplinkProcessing("queueStartTs", "queueSeqIdOffset", true, (arg_0, arg_1, arg_2, arg_3) -> ((CloudEventService)this.cloudEventService).findCloudEvents(arg_0, arg_1, arg_2, arg_3)));
        }
        if (this.tsExecutor == null) {
            this.tsExecutor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"postgres-ts-cloud-manager"));
            this.tsExecutor.submit(() -> this.launchUplinkProcessing("queueTsKvStartTs", "queueTsKvSeqIdOffset", false, (arg_0, arg_1, arg_2, arg_3) -> ((CloudEventService)this.cloudEventService).findTsKvCloudEvents(arg_0, arg_1, arg_2, arg_3)));
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdownNow();
            this.executor = null;
        }
        if (this.tsExecutor != null && !this.tsExecutor.isShutdown()) {
            this.tsExecutor.shutdownNow();
            this.tsExecutor = null;
        }
    }

    private void launchUplinkProcessing(String queueStartTsAttrKey, String queueSeqIdAttrKey, boolean isGeneralMsg, CloudEventFinder finder) {
        while (!Thread.interrupted()) {
            try {
                if (this.edgeInfo.isInitialized() && !this.edgeInfo.isSyncInProgress()) {
                    if (!isGeneralMsg && this.edgeInfo.isGeneralProcessInProgress()) continue;
                    Long queueSeqIdStart = (Long)this.getLongAttrByKey(this.edgeInfo.getTenantId(), queueSeqIdAttrKey).get();
                    TimePageLink pageLink = this.cloudEventUplinkRetriever.newCloudEventsAvailable(this.edgeInfo.getTenantId(), queueSeqIdStart, queueStartTsAttrKey, finder);
                    if (pageLink != null) {
                        this.cloudEventUplinkBatchDispatcher.processUplinkMessages(pageLink, queueSeqIdStart, queueStartTsAttrKey, queueSeqIdAttrKey, isGeneralMsg, finder);
                        continue;
                    }
                    log.trace("no new cloud events found for queue, isGeneralMsg = {}", (Object)isGeneralMsg);
                    this.sleep();
                    continue;
                }
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (Exception e) {
                log.warn("Failed to process messages handling!", (Throwable)e);
            }
        }
    }

    private void sleep() {
        try {
            Thread.sleep(this.cloudEventStorageSettings.getNoRecordsSleepInterval());
        }
        catch (InterruptedException e) {
            log.error("Error during sleep", (Throwable)e);
        }
    }

    private ListenableFuture<Long> getLongAttrByKey(TenantId tenantId, String attrKey) {
        ListenableFuture future = this.attributesService.find(tenantId, (EntityId)tenantId, AttributeScope.SERVER_SCOPE, attrKey);
        return Futures.transform((ListenableFuture)future, attributeKvEntryOpt -> {
            if (attributeKvEntryOpt != null && attributeKvEntryOpt.isPresent()) {
                AttributeKvEntry attributeKvEntry = (AttributeKvEntry)attributeKvEntryOpt.get();
                return attributeKvEntry.getLongValue().isPresent() ? (Long)attributeKvEntry.getLongValue().get() : 0L;
            }
            return 0L;
        }, (Executor)this.dbCallbackExecutorService);
    }

    @ConstructorProperties(value={"cloudEventUplinkBatchDispatcher", "cloudEventUplinkRetriever", "dbCallbackExecutorService", "cloudEventStorageSettings", "cloudEventService", "attributesService", "edgeInfo"})
    @Generated
    public PostgresCloudEventUplinkProcessingRunner(BasePostgresCloudEventUplinkBatchDispatcher cloudEventUplinkBatchDispatcher, PostgresCloudEventUplinkRetriever cloudEventUplinkRetriever, DbCallbackExecutorService dbCallbackExecutorService, CloudEventStorageSettings cloudEventStorageSettings, CloudEventService cloudEventService, AttributesService attributesService, EdgeInfoHolder edgeInfo) {
        this.cloudEventUplinkBatchDispatcher = cloudEventUplinkBatchDispatcher;
        this.cloudEventUplinkRetriever = cloudEventUplinkRetriever;
        this.dbCallbackExecutorService = dbCallbackExecutorService;
        this.cloudEventStorageSettings = cloudEventStorageSettings;
        this.cloudEventService = cloudEventService;
        this.attributesService = attributesService;
        this.edgeInfo = edgeInfo;
    }
}

