/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.event.runner;

import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.common.consumer.QueueConsumerManager;
import org.thingsboard.server.queue.provider.TbCloudEventQueueFactory;
import org.thingsboard.server.queue.settings.TbQueueCloudEventSettings;
import org.thingsboard.server.queue.settings.TbQueueCloudEventTSSettings;
import org.thingsboard.server.service.cloud.event.runner.CloudEventUplinkProcessingRunner;
import org.thingsboard.server.service.cloud.event.sender.GrpcCloudEventUplinkSender;
import org.thingsboard.server.service.cloud.info.EdgeInfoHolder;
import org.thingsboard.server.service.cloud.rpc.CloudEventStorageSettings;

@Service
@ConditionalOnExpression(value="'${queue.type:null}'=='kafka'")
public class KafkaCloudEventUplinkProcessingRunner
implements CloudEventUplinkProcessingRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaCloudEventUplinkProcessingRunner.class);
    private final TbQueueCloudEventTSSettings tbQueueCloudEventTSSettings;
    private final TbQueueCloudEventSettings tbQueueCloudEventSettings;
    private final CloudEventStorageSettings cloudEventStorageSettings;
    private final TbCloudEventQueueFactory tbCloudEventQueueProvider;
    private final GrpcCloudEventUplinkSender cloudEventUplinkSender;
    private final EdgeInfoHolder edgeInfo;
    private QueueConsumerManager<TbProtoQueueMsg<TransportProtos.ToCloudEventMsg>> consumer;
    private QueueConsumerManager<TbProtoQueueMsg<TransportProtos.ToCloudEventMsg>> tsConsumer;
    private ExecutorService consumerExecutor;
    private ExecutorService tsConsumerExecutor;

    public void init() {
        if (this.consumer == null) {
            this.consumerExecutor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"cloud-event-consumer"));
            this.consumer = QueueConsumerManager.builder().name("TB Cloud Events").msgPackProcessor((arg_0, arg_1) -> this.processUplinkMessages(arg_0, arg_1)).pollInterval(this.tbQueueCloudEventSettings.getPollInterval().longValue()).consumerCreator(() -> ((TbCloudEventQueueFactory)this.tbCloudEventQueueProvider).createCloudEventMsgConsumer()).consumerExecutor(this.consumerExecutor).threadPrefix("cloud-events").build();
            this.consumer.subscribe();
            this.consumer.launch();
        }
        if (this.tsConsumer == null) {
            this.tsConsumerExecutor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"ts-cloud-event-consumer"));
            this.tsConsumer = QueueConsumerManager.builder().name("TB TS Cloud Events").msgPackProcessor((arg_0, arg_1) -> this.processTsUplinkMessages(arg_0, arg_1)).pollInterval(this.tbQueueCloudEventTSSettings.getPollInterval().longValue()).consumerCreator(() -> ((TbCloudEventQueueFactory)this.tbCloudEventQueueProvider).createCloudEventTSMsgConsumer()).consumerExecutor(this.tsConsumerExecutor).threadPrefix("ts-cloud-events").build();
            this.tsConsumer.subscribe();
            this.tsConsumer.launch();
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.consumer != null) {
            this.consumer.stop();
            this.consumer = null;
            this.consumerExecutor.shutdown();
        }
        if (this.tsConsumer != null) {
            this.tsConsumer.stop();
            this.tsConsumer = null;
            this.tsConsumerExecutor.shutdown();
        }
    }

    private void processUplinkMessages(List<TbProtoQueueMsg<TransportProtos.ToCloudEventMsg>> msgs, TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToCloudEventMsg>> consumer) {
        boolean isProcessed = false;
        int attempt = 1;
        do {
            log.trace("[{}] Trying to process general uplink messages, attempt: {}", (Object)this.edgeInfo.getTenantId(), (Object)attempt++);
            if (this.canProcessGeneralMessages()) {
                this.edgeInfo.setGeneralProcessInProgress(true);
                isProcessed = this.doProcessMessages(msgs, consumer, true);
                this.edgeInfo.setGeneralProcessInProgress(false);
            } else {
                log.debug("[{}] Waiting: initialized={}, syncInProgress={}", new Object[]{this.edgeInfo.getTenantId(), this.edgeInfo.isInitialized(), this.edgeInfo.isSyncInProgress()});
            }
            if (isProcessed) continue;
            this.sleep();
        } while (!isProcessed);
    }

    private void processTsUplinkMessages(List<TbProtoQueueMsg<TransportProtos.ToCloudEventMsg>> msgs, TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToCloudEventMsg>> consumer) {
        boolean isProcessed = false;
        do {
            log.trace("[{}] Trying to process TS uplink messages", (Object)this.edgeInfo.getTenantId());
            if (this.canProcessTsMessages()) {
                isProcessed = this.doProcessMessages(msgs, consumer, false);
            } else {
                log.debug("[{}] Waiting: initialized={}, syncInProgress={}, generalInProgress={}", new Object[]{this.edgeInfo.getTenantId(), this.edgeInfo.isInitialized(), this.edgeInfo.isSyncInProgress(), this.edgeInfo.isGeneralProcessInProgress()});
            }
            if (isProcessed) continue;
            this.sleep();
        } while (!isProcessed);
    }

    private void sleep() {
        try {
            Thread.sleep(this.cloudEventStorageSettings.getNoRecordsSleepInterval());
        }
        catch (InterruptedException interruptedException) {
            log.trace("Interrupted while waiting to retry uplink processing", (Throwable)interruptedException);
        }
    }

    private boolean doProcessMessages(List<TbProtoQueueMsg<TransportProtos.ToCloudEventMsg>> msgs, TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToCloudEventMsg>> consumer, boolean isGeneralMsg) {
        boolean isInterrupted;
        List cloudEvents = this.convertQueueMsgsToCloudEvents(msgs);
        try {
            isInterrupted = (Boolean)this.cloudEventUplinkSender.sendCloudEvents(cloudEvents, isGeneralMsg).get();
        }
        catch (Exception e) {
            log.error("Failed to process all uplink messages", (Throwable)e);
            return false;
        }
        if (isInterrupted) {
            log.warn("[{}] Send uplink messages task was interrupted", (Object)this.edgeInfo.getTenantId());
            return false;
        }
        consumer.commit();
        log.trace("[{}] Successfully processed {} uplink messages (type={})", new Object[]{this.edgeInfo.getTenantId(), cloudEvents.size(), isGeneralMsg ? "GENERAL" : "TS"});
        return true;
    }

    private List<CloudEvent> convertQueueMsgsToCloudEvents(List<TbProtoQueueMsg<TransportProtos.ToCloudEventMsg>> msgs) {
        return msgs.stream().map(msg -> ProtoUtils.fromProto((TransportProtos.CloudEventMsgProto)((TransportProtos.ToCloudEventMsg)msg.getValue()).getCloudEventMsg())).toList();
    }

    private boolean canProcessTsMessages() {
        return this.edgeInfo.isInitialized() && !this.edgeInfo.isSyncInProgress() && !this.edgeInfo.isGeneralProcessInProgress();
    }

    private boolean canProcessGeneralMessages() {
        return this.edgeInfo.isInitialized() && !this.edgeInfo.isSyncInProgress();
    }

    @ConstructorProperties(value={"tbQueueCloudEventTSSettings", "tbQueueCloudEventSettings", "cloudEventStorageSettings", "tbCloudEventQueueProvider", "cloudEventUplinkSender", "edgeInfo"})
    @Generated
    public KafkaCloudEventUplinkProcessingRunner(TbQueueCloudEventTSSettings tbQueueCloudEventTSSettings, TbQueueCloudEventSettings tbQueueCloudEventSettings, CloudEventStorageSettings cloudEventStorageSettings, TbCloudEventQueueFactory tbCloudEventQueueProvider, GrpcCloudEventUplinkSender cloudEventUplinkSender, EdgeInfoHolder edgeInfo) {
        this.tbQueueCloudEventTSSettings = tbQueueCloudEventTSSettings;
        this.tbQueueCloudEventSettings = tbQueueCloudEventSettings;
        this.cloudEventStorageSettings = cloudEventStorageSettings;
        this.tbCloudEventQueueProvider = tbCloudEventQueueProvider;
        this.cloudEventUplinkSender = cloudEventUplinkSender;
        this.edgeInfo = edgeInfo;
    }
}

