/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.event.postgres;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.beans.ConstructorProperties;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.service.cloud.CloudContextComponent;
import org.thingsboard.server.service.cloud.CloudEventFinder;
import org.thingsboard.server.service.cloud.rpc.CloudEventStorageSettings;
import org.thingsboard.server.service.executors.DbCallbackExecutorService;

@Service
public class PostgresCloudEventUplinkRetriever {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostgresCloudEventUplinkRetriever.class);
    private final DbCallbackExecutorService dbCallbackExecutorService;
    private final CloudEventStorageSettings cloudEventStorageSettings;
    private final AttributesService attributesService;
    private final CloudContextComponent cloudCtx;

    public TimePageLink newCloudEventsAvailable(TenantId tenantId, Long queueSeqIdStart, String key, CloudEventFinder finder) {
        try {
            long queueStartTs = (Long)this.getLongAttrByKey(tenantId, key).get();
            queueStartTs = queueStartTs > 0L ? queueStartTs - this.cloudCtx.getCloudEventStorageSettings().getMisorderingCompensationMillis() : 0L;
            long queueEndTs = queueStartTs > 0L ? queueStartTs + TimeUnit.DAYS.toMillis(1L) : System.currentTimeMillis();
            log.trace("newCloudEventsAvailable, queueSeqIdStart = {}, key = {}, queueStartTs = {}, queueEndTs = {}", new Object[]{queueSeqIdStart, key, queueStartTs, queueEndTs});
            TimePageLink pageLink = new TimePageLink(this.cloudEventStorageSettings.getMaxReadRecordsCount(), 0, null, null, Long.valueOf(queueStartTs), Long.valueOf(queueEndTs));
            PageData cloudEvents = finder.find(tenantId, queueSeqIdStart, null, pageLink);
            if (cloudEvents.getData().isEmpty()) {
                if (queueSeqIdStart > (long)this.cloudEventStorageSettings.getMaxReadRecordsCount() && (cloudEvents = this.findCloudEventsFromBeginning(tenantId, pageLink, finder)).getData().stream().anyMatch(ce -> ce.getSeqId() == 1L)) {
                    log.info("newCloudEventsAvailable: new cycle started (seq_id starts from '1')!");
                    return pageLink;
                }
                while (queueEndTs < System.currentTimeMillis()) {
                    log.trace("newCloudEventsAvailable: queueEndTs < System.currentTimeMillis() [{}] [{}]", (Object)queueEndTs, (Object)System.currentTimeMillis());
                    queueStartTs = queueEndTs;
                    pageLink = new TimePageLink(this.cloudEventStorageSettings.getMaxReadRecordsCount(), 0, null, null, Long.valueOf(queueStartTs), Long.valueOf(queueEndTs += TimeUnit.DAYS.toMillis(1L)));
                    cloudEvents = finder.find(tenantId, queueSeqIdStart, null, pageLink);
                    if (cloudEvents.getData().isEmpty()) continue;
                    return pageLink;
                }
                return null;
            }
            return pageLink;
        }
        catch (Exception e) {
            log.warn("Failed to check newCloudEventsAvailable!", (Throwable)e);
            return null;
        }
    }

    public PageData<CloudEvent> findCloudEventsFromBeginning(TenantId tenantId, TimePageLink pageLink, CloudEventFinder finder) {
        long seqIdEnd = Integer.toUnsignedLong(this.cloudEventStorageSettings.getMaxReadRecordsCount());
        seqIdEnd = Math.max(seqIdEnd, 50L);
        return finder.find(tenantId, Long.valueOf(0L), Long.valueOf(seqIdEnd), pageLink);
    }

    private ListenableFuture<Long> getLongAttrByKey(TenantId tenantId, String attrKey) {
        ListenableFuture future = this.attributesService.find(tenantId, (EntityId)tenantId, AttributeScope.SERVER_SCOPE, attrKey);
        return Futures.transform((ListenableFuture)future, attributeKvEntryOpt -> {
            if (attributeKvEntryOpt != null && attributeKvEntryOpt.isPresent()) {
                AttributeKvEntry attributeKvEntry = (AttributeKvEntry)attributeKvEntryOpt.get();
                return attributeKvEntry.getLongValue().isPresent() ? (Long)attributeKvEntry.getLongValue().get() : 0L;
            }
            return 0L;
        }, (Executor)this.dbCallbackExecutorService);
    }

    @ConstructorProperties(value={"dbCallbackExecutorService", "cloudEventStorageSettings", "attributesService", "cloudCtx"})
    @Generated
    public PostgresCloudEventUplinkRetriever(DbCallbackExecutorService dbCallbackExecutorService, CloudEventStorageSettings cloudEventStorageSettings, AttributesService attributesService, CloudContextComponent cloudCtx) {
        this.dbCallbackExecutorService = dbCallbackExecutorService;
        this.cloudEventStorageSettings = cloudEventStorageSettings;
        this.attributesService = attributesService;
        this.cloudCtx = cloudCtx;
    }
}

