/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.event.migrator;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.service.cloud.CloudEventFinder;
import org.thingsboard.server.service.cloud.PostgresCloudEventService;
import org.thingsboard.server.service.cloud.event.migrator.CloudEventMigrationService;
import org.thingsboard.server.service.cloud.event.postgres.PostgresCloudEventUplinkRetriever;
import org.thingsboard.server.service.cloud.event.postgres.PostgresToKafkaCloudEventUplinkMigrationDispatcher;
import org.thingsboard.server.service.cloud.info.EdgeInfoHolder;
import org.thingsboard.server.service.executors.DbCallbackExecutorService;

@Service
@ConditionalOnExpression(value="'${queue.type:null}'=='kafka'")
public class KafkaCloudEventMigrationService
implements CloudEventMigrationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaCloudEventMigrationService.class);
    private final PostgresCloudEventService postgresCloudEventService;
    private final PostgresToKafkaCloudEventUplinkMigrationDispatcher postgresToKafkaMigrationEventsDispatcher;
    private final PostgresCloudEventUplinkRetriever postgresCloudEventUplinkRetriever;
    private final DbCallbackExecutorService dbCallbackExecutorService;
    private final AttributesService attributesService;
    private final EdgeInfoHolder edgeInfo;
    private ExecutorService executor;
    private volatile boolean isMigrated = false;
    private volatile boolean isTsMigrated = false;

    @PostConstruct
    private void onInit() {
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"postgres-cloud-migrator"));
    }

    @PreDestroy
    private void onDestroy() {
        this.shutdownSafely();
    }

    public boolean isMigrationRequired() {
        return !this.isMigrated || !this.isTsMigrated;
    }

    public void migrateUnprocessedEventToKafka() {
        this.executor.submit(() -> {
            try {
                while (!Thread.interrupted()) {
                    if (!this.edgeInfo.isInitialized()) {
                        TimeUnit.SECONDS.sleep(1L);
                        continue;
                    }
                    this.processMigration();
                    if (!this.isMigrated || !this.isTsMigrated) continue;
                    break;
                }
            }
            catch (Exception e) {
                log.warn("Failed to process messages handling!", (Throwable)e);
            }
            finally {
                this.shutdownSafely();
            }
        });
    }

    private void processMigration() throws Exception {
        boolean isGeneralMsg;
        CloudEventFinder finder;
        if (!this.isMigrated) {
            finder = (arg_0, arg_1, arg_2, arg_3) -> ((PostgresCloudEventService)this.postgresCloudEventService).findCloudEvents(arg_0, arg_1, arg_2, arg_3);
            isGeneralMsg = true;
            this.isMigrated = this.launchCloudEventProcessing("queueSeqIdOffset", "queueStartTs", isGeneralMsg, finder);
        }
        if (!this.isTsMigrated) {
            finder = (arg_0, arg_1, arg_2, arg_3) -> ((PostgresCloudEventService)this.postgresCloudEventService).findTsKvCloudEvents(arg_0, arg_1, arg_2, arg_3);
            isGeneralMsg = false;
            this.isTsMigrated = this.launchCloudEventProcessing("queueTsKvSeqIdOffset", "queueTsKvStartTs", isGeneralMsg, finder);
        }
    }

    private boolean launchCloudEventProcessing(String seqIdKey, String startTsKey, boolean isGeneralMsg, CloudEventFinder finder) throws Exception {
        Long queueSeqIdStart = (Long)this.getLongAttrByKey(this.edgeInfo.getTenantId(), seqIdKey).get();
        TimePageLink pageLink = this.postgresCloudEventUplinkRetriever.newCloudEventsAvailable(this.edgeInfo.getTenantId(), queueSeqIdStart, startTsKey, finder);
        if (pageLink != null) {
            this.postgresToKafkaMigrationEventsDispatcher.processUplinkMessages(pageLink, queueSeqIdStart, startTsKey, seqIdKey, isGeneralMsg, finder);
            return false;
        }
        return true;
    }

    private ListenableFuture<Long> getLongAttrByKey(TenantId tenantId, String attrKey) {
        ListenableFuture future = this.attributesService.find(tenantId, (EntityId)tenantId, AttributeScope.SERVER_SCOPE, attrKey);
        return Futures.transform((ListenableFuture)future, attributeKvEntryOpt -> {
            if (attributeKvEntryOpt != null && attributeKvEntryOpt.isPresent()) {
                AttributeKvEntry attributeKvEntry = (AttributeKvEntry)attributeKvEntryOpt.get();
                return attributeKvEntry.getLongValue().isPresent() ? (Long)attributeKvEntry.getLongValue().get() : 0L;
            }
            return 0L;
        }, (Executor)this.dbCallbackExecutorService);
    }

    private void shutdownSafely() {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
        }
    }

    @ConstructorProperties(value={"postgresCloudEventService", "postgresToKafkaMigrationEventsDispatcher", "postgresCloudEventUplinkRetriever", "dbCallbackExecutorService", "attributesService", "edgeInfo"})
    @Generated
    public KafkaCloudEventMigrationService(PostgresCloudEventService postgresCloudEventService, PostgresToKafkaCloudEventUplinkMigrationDispatcher postgresToKafkaMigrationEventsDispatcher, PostgresCloudEventUplinkRetriever postgresCloudEventUplinkRetriever, DbCallbackExecutorService dbCallbackExecutorService, AttributesService attributesService, EdgeInfoHolder edgeInfo) {
        this.postgresCloudEventService = postgresCloudEventService;
        this.postgresToKafkaMigrationEventsDispatcher = postgresToKafkaMigrationEventsDispatcher;
        this.postgresCloudEventUplinkRetriever = postgresCloudEventUplinkRetriever;
        this.dbCallbackExecutorService = dbCallbackExecutorService;
        this.attributesService = attributesService;
        this.edgeInfo = edgeInfo;
    }
}

