/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.cloud.CloudEventDao;
import org.thingsboard.server.dao.cloud.CloudEventService;
import org.thingsboard.server.dao.cloud.TsKvCloudEventDao;
import org.thingsboard.server.dao.edge.stats.CloudStatsCounterService;
import org.thingsboard.server.dao.service.DataValidator;

@Service
public class PostgresCloudEventService
implements CloudEventService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostgresCloudEventService.class);
    private static final List<EdgeEventActionType> CLOUD_EVENT_ACTION_WITHOUT_DUPLICATES = List.of(EdgeEventActionType.ATTRIBUTES_REQUEST, EdgeEventActionType.RELATION_REQUEST, EdgeEventActionType.GROUP_ENTITIES_REQUEST, EdgeEventActionType.GROUP_PERMISSIONS_REQUEST, EdgeEventActionType.CALCULATED_FIELD_REQUEST);
    private final CloudStatsCounterService statsCounterService;
    private final AttributesService attributesService;
    private final CloudEventDao cloudEventDao;
    private final TsKvCloudEventDao tsKvCloudEventDao;
    private final DataValidator<CloudEvent> cloudEventValidator;

    public void saveCloudEvent(TenantId tenantId, CloudEventType cloudEventType, EdgeEventActionType cloudEventAction, EntityId entityId, JsonNode entityBody, EntityGroupId entityGroupId) throws ExecutionException, InterruptedException {
        this.saveCloudEventAsync(tenantId, cloudEventType, cloudEventAction, entityId, entityBody, entityGroupId).get();
    }

    public ListenableFuture<Void> saveCloudEventAsync(TenantId tenantId, CloudEventType cloudEventType, EdgeEventActionType cloudEventAction, EntityId entityId, JsonNode entityBody, EntityGroupId entityGroupId) {
        if (this.shouldAddEventToQueue(tenantId, cloudEventType, cloudEventAction, entityId)) {
            CloudEvent cloudEvent = new CloudEvent(tenantId, cloudEventAction, entityId != null ? entityId.getId() : null, cloudEventType, entityBody, entityGroupId != null ? entityGroupId.getId() : null);
            return this.saveAsync(cloudEvent);
        }
        return Futures.immediateFuture(null);
    }

    private boolean shouldAddEventToQueue(TenantId tenantId, CloudEventType cloudEventType, EdgeEventActionType cloudEventAction, EntityId entityId) {
        Long queueStartTs = null;
        try {
            Optional attributeKvEntry = (Optional)this.attributesService.find(tenantId, (EntityId)tenantId, AttributeScope.SERVER_SCOPE, "queueStartTs").get();
            if (attributeKvEntry.isPresent() && ((AttributeKvEntry)attributeKvEntry.get()).getLongValue().isPresent()) {
                queueStartTs = (Long)((AttributeKvEntry)attributeKvEntry.get()).getLongValue().get();
            }
        }
        catch (Exception attributeKvEntry) {
            // empty catch block
        }
        if (queueStartTs == null || queueStartTs <= 0L || !CLOUD_EVENT_ACTION_WITHOUT_DUPLICATES.contains(cloudEventAction)) {
            return true;
        }
        long countMsgsInQueue = this.cloudEventDao.countEventsByTenantIdAndEntityIdAndActionAndTypeAndStartTimeAndEndTime(tenantId.getId(), entityId.getId(), cloudEventType, cloudEventAction, queueStartTs, Long.valueOf(System.currentTimeMillis()));
        if (countMsgsInQueue > 0L) {
            log.info("{} Skipping adding of {} event because it's already present in db {} {}", new Object[]{tenantId, cloudEventAction, entityId, cloudEventType});
            return false;
        }
        return true;
    }

    public ListenableFuture<Void> saveAsync(CloudEvent cloudEvent) {
        this.cloudEventValidator.validate((BaseData)cloudEvent, CloudEvent::getTenantId);
        log.trace("Save cloud event {}", (Object)cloudEvent);
        return this.handleSaveResult(cloudEvent, this.cloudEventDao.saveAsync(cloudEvent));
    }

    public ListenableFuture<Void> saveTsKvAsync(CloudEvent cloudEvent) {
        this.cloudEventValidator.validate((BaseData)cloudEvent, CloudEvent::getTenantId);
        return this.handleSaveResult(cloudEvent, this.tsKvCloudEventDao.saveAsync(cloudEvent));
    }

    private ListenableFuture<Void> handleSaveResult(CloudEvent cloudEvent, ListenableFuture<Void> saveFuture) {
        Futures.addCallback(saveFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)MoreExecutors.directExecutor());
        return saveFuture;
    }

    public PageData<CloudEvent> findCloudEvents(TenantId tenantId, Long seqIdStart, Long seqIdEnd, TimePageLink pageLink) {
        return this.cloudEventDao.findCloudEvents(tenantId.getId(), seqIdStart, seqIdEnd, pageLink);
    }

    public PageData<CloudEvent> findTsKvCloudEvents(TenantId tenantId, Long seqIdStart, Long seqIdEnd, TimePageLink pageLink) {
        return this.tsKvCloudEventDao.findCloudEvents(tenantId.getId(), seqIdStart, seqIdEnd, pageLink);
    }

    @ConstructorProperties(value={"statsCounterService", "attributesService", "cloudEventDao", "tsKvCloudEventDao", "cloudEventValidator"})
    @Generated
    public PostgresCloudEventService(CloudStatsCounterService statsCounterService, AttributesService attributesService, CloudEventDao cloudEventDao, TsKvCloudEventDao tsKvCloudEventDao, DataValidator<CloudEvent> cloudEventValidator) {
        this.statsCounterService = statsCounterService;
        this.attributesService = attributesService;
        this.cloudEventDao = cloudEventDao;
        this.tsKvCloudEventDao = tsKvCloudEventDao;
        this.cloudEventValidator = cloudEventValidator;
    }
}

