/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmComment;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.dao.cloud.CloudSynchronizationManager;
import org.thingsboard.server.dao.eventsourcing.ActionEntityEvent;
import org.thingsboard.server.dao.eventsourcing.DeleteEntityEvent;
import org.thingsboard.server.dao.eventsourcing.RelationActionEvent;
import org.thingsboard.server.dao.eventsourcing.SaveEntityEvent;
import org.thingsboard.server.dao.tenant.TenantService;

@Component
public class CloudEventSourcingListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudEventSourcingListener.class);
    private final TbClusterService tbClusterService;
    private final TenantService tenantService;
    private final CloudSynchronizationManager cloudSynchronizationManager;
    private static final List<EntityType> COMMON_ENTITY_TYPES = Arrays.asList(EntityType.DEVICE, EntityType.DEVICE_PROFILE, EntityType.ENTITY_VIEW, EntityType.ASSET, EntityType.ASSET_PROFILE, EntityType.DASHBOARD, EntityType.RULE_CHAIN, EntityType.TB_RESOURCE, EntityType.CALCULATED_FIELD, EntityType.SCHEDULER_EVENT, EntityType.REPORT_TEMPLATE, EntityType.USER, EntityType.AI_MODEL);
    private final List<EntityType> supportableEntityTypes = new /* Unavailable Anonymous Inner Class!! */;
    private final List<EntityType> baseEventSupportableEntityTypes = new ArrayList(COMMON_ENTITY_TYPES);

    @PostConstruct
    public void init() {
        log.info("CloudEventSourcingListener initiated");
    }

    @TransactionalEventListener(fallbackExecution=true)
    public void handleEvent(SaveEntityEvent<?> event) {
        if (this.cloudSynchronizationManager.isSync()) {
            return;
        }
        try {
            if (event.getEntityId() != null && !this.baseEventSupportableEntityTypes.contains(event.getEntityId().getEntityType()) && !(event.getEntity() instanceof AlarmComment)) {
                return;
            }
            log.trace("SaveEntityEvent called: {}", event);
            boolean isCreated = Boolean.TRUE.equals(event.getCreated());
            String body = this.getBodyMsgForEntityEvent(event.getEntity());
            CloudEventType cloudEventType = this.getCloudEventTypeForEntityEvent(event.getEntity());
            EdgeEventActionType action = this.getActionForEntityEvent(event.getEntity(), isCreated);
            this.tbClusterService.sendNotificationMsgToCloud(event.getTenantId(), event.getEntityId(), body, cloudEventType, action, null);
        }
        catch (Exception e) {
            log.error("failed to process SaveEntityEvent: {}", event);
        }
    }

    @TransactionalEventListener(fallbackExecution=true)
    public void handleEvent(DeleteEntityEvent<?> event) {
        if (this.cloudSynchronizationManager.isSync()) {
            return;
        }
        TenantId tenantId = event.getTenantId();
        if (!tenantId.isSysTenantId() && !this.tenantService.tenantExists(tenantId)) {
            log.debug("[{}] Ignoring DeleteEntityEvent because tenant does not exist: {}", (Object)tenantId, event);
            return;
        }
        try {
            if (event.getEntityId() != null && !this.supportableEntityTypes.contains(event.getEntityId().getEntityType()) && !(event.getEntity() instanceof AlarmComment)) {
                return;
            }
            log.trace("DeleteEntityEvent called: {}", event);
            CloudEventType type = this.getCloudEventTypeForEntityEvent(event.getEntity());
            EdgeEventActionType actionType = this.getEdgeEventActionTypeForEntityEvent(event.getEntity());
            this.tbClusterService.sendNotificationMsgToCloud(event.getTenantId(), event.getEntityId(), JacksonUtil.toString((Object)event.getEntity()), type, actionType, null);
        }
        catch (Exception e) {
            log.error("failed to process DeleteEntityEvent: {}", event, (Object)e);
        }
    }

    @TransactionalEventListener(fallbackExecution=true)
    public void handleEvent(ActionEntityEvent<?> event) {
        if (this.cloudSynchronizationManager.isSync()) {
            return;
        }
        try {
            if (event.getEntityId() != null && !this.baseEventSupportableEntityTypes.contains(event.getEntityId().getEntityType())) {
                return;
            }
            if (event.getEntityGroup() != null && event.getEntityGroup().isGroupAll()) {
                log.trace("skipping entity in case of 'All' group: {}", event);
                return;
            }
            log.trace("ActionEntityEvent called: {}", event);
            EntityGroupId entityGroupId = event.getEntityGroup() != null ? event.getEntityGroup().getId() : null;
            this.tbClusterService.sendNotificationMsgToCloud(event.getTenantId(), event.getEntityId(), event.getBody(), null, EdgeUtils.getEdgeEventActionTypeByActionType((ActionType)event.getActionType()), entityGroupId);
        }
        catch (Exception e) {
            log.error("failed to process ActionEntityEvent: {}", event);
        }
    }

    @TransactionalEventListener(fallbackExecution=true)
    public void handleEvent(RelationActionEvent event) {
        if (this.cloudSynchronizationManager.isSync()) {
            return;
        }
        try {
            EntityRelation relation = event.getRelation();
            if (relation == null) {
                log.trace("[{}] skipping RelationActionEvent event in case relation is null: {}", (Object)event.getTenantId(), (Object)event);
                return;
            }
            if (!RelationTypeGroup.COMMON.equals((Object)relation.getTypeGroup())) {
                log.trace("[{}] skipping RelationActionEvent event in case NOT COMMON relation type group: {}", (Object)event.getTenantId(), (Object)event);
                return;
            }
            log.trace("RelationActionEvent called: {}", (Object)event);
            this.tbClusterService.sendNotificationMsgToCloud(event.getTenantId(), null, JacksonUtil.toString((Object)event.getRelation()), CloudEventType.RELATION, EdgeUtils.getEdgeEventActionTypeByActionType((ActionType)event.getActionType()), null);
        }
        catch (Exception e) {
            log.error("failed to process RelationActionEvent: {}", (Object)event);
        }
    }

    private CloudEventType getCloudEventTypeForEntityEvent(Object entity) {
        if (entity instanceof AlarmComment) {
            return CloudEventType.ALARM_COMMENT;
        }
        return null;
    }

    private EdgeEventActionType getEdgeEventActionTypeForEntityEvent(Object entity) {
        if (entity instanceof AlarmComment) {
            return EdgeEventActionType.DELETED_COMMENT;
        }
        if (entity instanceof Alarm) {
            return EdgeEventActionType.ALARM_DELETE;
        }
        return EdgeEventActionType.DELETED;
    }

    private String getBodyMsgForEntityEvent(Object entity) {
        if (entity instanceof AlarmComment) {
            return JacksonUtil.toString((Object)entity);
        }
        return null;
    }

    private EdgeEventActionType getActionForEntityEvent(Object entity, boolean isCreated) {
        if (entity instanceof AlarmComment) {
            return isCreated ? EdgeEventActionType.ADDED_COMMENT : EdgeEventActionType.UPDATED_COMMENT;
        }
        return isCreated ? EdgeEventActionType.ADDED : EdgeEventActionType.UPDATED;
    }

    @ConstructorProperties(value={"tbClusterService", "tenantService", "cloudSynchronizationManager"})
    @Generated
    public CloudEventSourcingListener(TbClusterService tbClusterService, TenantService tenantService, CloudSynchronizationManager cloudSynchronizationManager) {
        this.tbClusterService = tbClusterService;
        this.tenantService = tenantService;
        this.cloudSynchronizationManager = cloudSynchronizationManager;
    }
}

