/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.thingsboard.server.dao.eventsourcing.GrpcConnectionEstablishedEvent;
import org.thingsboard.server.dao.eventsourcing.StopCloudEventProcessingEvent;
import org.thingsboard.server.service.cloud.event.runner.CloudEventUplinkProcessingRunner;
import org.thingsboard.server.service.cloud.event.sender.CloudEventUplinkSender;

@Service
public class CloudEventProcessingLifecycleManager {
    private final CloudEventUplinkProcessingRunner cloudEventUplinkProcessingRunner;
    private final List<CloudEventUplinkSender> cloudEventUplinkSenders;

    @EventListener(value={GrpcConnectionEstablishedEvent.class})
    public void handleConnectionEvent() {
        this.cloudEventUplinkSenders.forEach(CloudEventUplinkSender::init);
        this.cloudEventUplinkProcessingRunner.init();
    }

    @EventListener(value={StopCloudEventProcessingEvent.class})
    public void handleStopEvent() {
        this.cloudEventUplinkProcessingRunner.shutdown();
        this.cloudEventUplinkSenders.forEach(CloudEventUplinkSender::shutdown);
    }

    @ConstructorProperties(value={"cloudEventUplinkProcessingRunner", "cloudEventUplinkSenders"})
    @Generated
    public CloudEventProcessingLifecycleManager(CloudEventUplinkProcessingRunner cloudEventUplinkProcessingRunner, List<CloudEventUplinkSender> cloudEventUplinkSenders) {
        this.cloudEventUplinkProcessingRunner = cloudEventUplinkProcessingRunner;
        this.cloudEventUplinkSenders = cloudEventUplinkSenders;
    }
}

