/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state.propagation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.Output;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.util.CollectionsUtil;
import org.thingsboard.server.service.cf.CalculatedFieldProcessingService;
import org.thingsboard.server.service.cf.CalculatedFieldResult;
import org.thingsboard.server.service.cf.PropagationCalculatedFieldResult;
import org.thingsboard.server.service.cf.TelemetryCalculatedFieldResult;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldScriptEngine;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.ScriptCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.SingleValueArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.propagation.PropagationArgumentEntry;

public class PropagationCalculatedFieldState
extends ScriptCalculatedFieldState {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PropagationCalculatedFieldState.class);
    private CalculatedFieldProcessingService cfProcessingService;

    public PropagationCalculatedFieldState(EntityId entityId) {
        super(entityId);
    }

    public void setCtx(CalculatedFieldCtx ctx, TbActorRef actorCtx) {
        this.ctx = ctx;
        this.actorCtx = actorCtx;
        this.cfProcessingService = ctx.getCfProcessingService();
        this.requiredArguments = new ArrayList(ctx.getArgNames());
        this.requiredArguments.add("propagationCtx");
        this.readinessStatus = this.checkReadiness();
        if (ctx.isApplyExpressionForResolvedArguments()) {
            this.tbelExpression = (CalculatedFieldScriptEngine)ctx.getTbelExpressions().get(ctx.getExpression());
        }
    }

    public void init(boolean restored) {
        super.init(restored);
        if (restored) {
            this.cfProcessingService.fetchPropagationArgumentFromDb(this.ctx, this.entityId).ifPresent(fromDb -> {
                fromDb.setSyncWithDb(true);
                Map updatedArgs = this.update(Map.of("propagationCtx", fromDb), this.ctx);
                if (updatedArgs.isEmpty()) {
                    return;
                }
                log.warn("[{}][{}] Propagation argument was out of sync during state restore and was reconciled with DB.", (Object)this.ctx.getCfId(), (Object)this.entityId);
                PropagationArgumentEntry updatedPropagationArgument = (PropagationArgumentEntry)this.arguments.get("propagationCtx");
                if (updatedPropagationArgument.getAdded() != null) {
                    log.warn("[{}][{}] New propagation entities were detected during restore. Scheduling reevaluation for new entities...", (Object)this.ctx.getCfId(), (Object)this.entityId);
                    this.ctx.scheduleReevaluation(0L, this.actorCtx);
                }
            });
        }
    }

    public CalculatedFieldType getType() {
        return CalculatedFieldType.PROPAGATION;
    }

    public ListenableFuture<CalculatedFieldResult> performCalculation(Map<String, ArgumentEntry> updatedArgs, CalculatedFieldCtx ctx) {
        List entityIds;
        boolean newEntityAdded;
        ArgumentEntry argumentEntry = (ArgumentEntry)this.arguments.get("propagationCtx");
        if (!(argumentEntry instanceof PropagationArgumentEntry)) {
            return Futures.immediateFuture((Object)PropagationCalculatedFieldResult.builder().build());
        }
        PropagationArgumentEntry propagationArgumentEntry = (PropagationArgumentEntry)argumentEntry;
        boolean bl = newEntityAdded = propagationArgumentEntry.getAdded() != null;
        if (newEntityAdded) {
            entityIds = propagationArgumentEntry.getAdded();
            propagationArgumentEntry.setAdded(null);
        } else {
            if (propagationArgumentEntry.getEntityIds().isEmpty()) {
                return Futures.immediateFuture((Object)PropagationCalculatedFieldResult.builder().build());
            }
            entityIds = List.copyOf(propagationArgumentEntry.getEntityIds());
        }
        if (ctx.isApplyExpressionForResolvedArguments()) {
            return Futures.transform((ListenableFuture)super.performCalculation(updatedArgs, ctx), telemetryCfResult -> PropagationCalculatedFieldResult.builder().entityIds(entityIds).result((TelemetryCalculatedFieldResult)telemetryCfResult).build(), (Executor)MoreExecutors.directExecutor());
        }
        if (newEntityAdded || CollectionsUtil.isEmpty(updatedArgs)) {
            updatedArgs = this.arguments;
        }
        return Futures.immediateFuture((Object)PropagationCalculatedFieldResult.builder().entityIds(entityIds).result(this.toTelemetryResult(ctx, updatedArgs)).build());
    }

    protected CalculatedFieldState.ReadinessStatus checkReadiness() {
        if (this.ctx.isApplyExpressionForResolvedArguments() || this.arguments == null) {
            return super.checkReadiness();
        }
        boolean propagationNotEmpty = false;
        boolean hasOtherNonEmpty = false;
        ArrayList<String> emptyArguments = null;
        for (String requiredArgumentKey : this.requiredArguments) {
            ArgumentEntry argumentEntry = (ArgumentEntry)this.arguments.get(requiredArgumentKey);
            if (argumentEntry == null || argumentEntry.isEmpty()) {
                if (emptyArguments == null) {
                    emptyArguments = new ArrayList<String>();
                }
                emptyArguments.add(requiredArgumentKey);
                continue;
            }
            if ("propagationCtx".equals(requiredArgumentKey)) {
                propagationNotEmpty = true;
                continue;
            }
            hasOtherNonEmpty = true;
        }
        if (propagationNotEmpty && hasOtherNonEmpty) {
            return CalculatedFieldState.ReadinessStatus.READY;
        }
        return CalculatedFieldState.ReadinessStatus.from(emptyArguments);
    }

    private TelemetryCalculatedFieldResult toTelemetryResult(CalculatedFieldCtx ctx, Map<String, ArgumentEntry> updatedArgs) {
        Output output = ctx.getOutput();
        TelemetryCalculatedFieldResult.TelemetryCalculatedFieldResultBuilder telemetryCfBuilder = TelemetryCalculatedFieldResult.builder().outputStrategy(output.getStrategy()).type(output.getType()).scope(output.getScope());
        ObjectNode valuesNode = JacksonUtil.newObjectNode();
        updatedArgs.forEach((outputKey, argumentEntry) -> {
            if (argumentEntry instanceof PropagationArgumentEntry) {
                return;
            }
            if (argumentEntry instanceof SingleValueArgumentEntry) {
                SingleValueArgumentEntry singleArgumentEntry = (SingleValueArgumentEntry)argumentEntry;
                if (!singleArgumentEntry.isEmpty()) {
                    JacksonUtil.addKvEntry((ObjectNode)valuesNode, (KvEntry)singleArgumentEntry.getKvEntryValue(), (String)outputKey);
                }
                return;
            }
            throw new IllegalArgumentException("Unsupported argument type: " + String.valueOf(argumentEntry.getType()) + " detected for argument: " + outputKey + ". Only Latest telemetry or Attribute arguments supported for 'Arguments Only' propagation mode!");
        });
        telemetryCfBuilder.result((JsonNode)this.toResultNode(valuesNode));
        return telemetryCfBuilder.build();
    }
}

