/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state.propagation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.thingsboard.script.api.tbel.TbelCfArg;
import org.thingsboard.script.api.tbel.TbelCfPropagationArg;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntryType;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.HasEntityLimit;

public class PropagationArgumentEntry
implements ArgumentEntry,
HasEntityLimit {
    private Set<EntityId> entityIds;
    private transient List<EntityId> added;
    private transient EntityId removed;
    private transient boolean forceResetPrevious;
    private transient boolean syncWithDb;

    public PropagationArgumentEntry() {
        this.entityIds = new HashSet();
        this.added = null;
        this.removed = null;
    }

    public PropagationArgumentEntry(List<EntityId> entityIds) {
        this.entityIds = new HashSet<EntityId>(entityIds);
    }

    public ArgumentEntryType getType() {
        return ArgumentEntryType.PROPAGATION;
    }

    public Object getValue() {
        return this.entityIds;
    }

    public boolean updateEntry(ArgumentEntry entry, CalculatedFieldCtx ctx) {
        if (!(entry instanceof PropagationArgumentEntry)) {
            throw new IllegalArgumentException("Unsupported argument entry type for propagation argument entry: " + String.valueOf(entry.getType()));
        }
        PropagationArgumentEntry updated = (PropagationArgumentEntry)entry;
        if (updated.getAdded() != null) {
            return this.checkAdded((Collection)updated.getAdded(), ctx);
        }
        if (updated.getRemoved() != null) {
            return this.entityIds.remove(updated.getRemoved());
        }
        if (updated.isSyncWithDb()) {
            Set dbEntityIds = updated.getEntityIds();
            if (dbEntityIds.isEmpty()) {
                if (this.entityIds.isEmpty()) {
                    return false;
                }
                this.entityIds.clear();
                return true;
            }
            boolean retained = this.entityIds.retainAll(dbEntityIds);
            boolean added = this.checkAdded((Collection)dbEntityIds, ctx);
            return retained || added;
        }
        if (updated.isEmpty()) {
            this.entityIds.clear();
            return true;
        }
        this.entityIds = updated.getEntityIds();
        return true;
    }

    private boolean checkAdded(Collection<EntityId> updatedIds, CalculatedFieldCtx ctx) {
        for (EntityId id : updatedIds) {
            this.checkEntityLimit(this.entityIds.size(), ctx);
            if (!this.entityIds.add(id)) continue;
            if (this.added == null) {
                this.added = new ArrayList();
            }
            this.added.add(id);
        }
        return this.added != null && !this.added.isEmpty();
    }

    public boolean isEmpty() {
        return this.entityIds.isEmpty();
    }

    public TbelCfArg toTbelCfArg() {
        return new TbelCfPropagationArg((Object)this.entityIds);
    }

    @Generated
    public Set<EntityId> getEntityIds() {
        return this.entityIds;
    }

    @Generated
    public List<EntityId> getAdded() {
        return this.added;
    }

    @Generated
    public EntityId getRemoved() {
        return this.removed;
    }

    @Generated
    public boolean isForceResetPrevious() {
        return this.forceResetPrevious;
    }

    @Generated
    public boolean isSyncWithDb() {
        return this.syncWithDb;
    }

    @Generated
    public void setEntityIds(Set<EntityId> entityIds) {
        this.entityIds = entityIds;
    }

    @Generated
    public void setAdded(List<EntityId> added) {
        this.added = added;
    }

    @Generated
    public void setRemoved(EntityId removed) {
        this.removed = removed;
    }

    @Generated
    public void setForceResetPrevious(boolean forceResetPrevious) {
        this.forceResetPrevious = forceResetPrevious;
    }

    @Generated
    public void setSyncWithDb(boolean syncWithDb) {
        this.syncWithDb = syncWithDb;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropagationArgumentEntry)) {
            return false;
        }
        PropagationArgumentEntry other = (PropagationArgumentEntry)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Set this$entityIds = this.getEntityIds();
        Set other$entityIds = other.getEntityIds();
        return !(this$entityIds == null ? other$entityIds != null : !((Object)this$entityIds).equals(other$entityIds));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PropagationArgumentEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set $entityIds = this.getEntityIds();
        result = result * 59 + ($entityIds == null ? 43 : ((Object)$entityIds).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PropagationArgumentEntry(entityIds=" + String.valueOf(this.getEntityIds()) + ", added=" + String.valueOf(this.getAdded()) + ", removed=" + String.valueOf(this.getRemoved()) + ", forceResetPrevious=" + this.isForceResetPrevious() + ", syncWithDb=" + this.isSyncWithDb() + ")";
    }
}

