/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state.geofencing;

import lombok.Generated;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.geo.Coordinates;
import org.thingsboard.common.util.geo.PerimeterDefinition;
import org.thingsboard.server.common.data.cf.configuration.geofencing.GeofencingPresenceStatus;
import org.thingsboard.server.common.data.cf.configuration.geofencing.GeofencingTransitionEvent;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.service.cf.ctx.state.geofencing.GeofencingEvalResult;

public class GeofencingZoneState {
    private final EntityId zoneId;
    private long ts;
    private Long version;
    private PerimeterDefinition perimeterDefinition;
    private GeofencingPresenceStatus lastPresence;

    public GeofencingZoneState(EntityId zoneId, KvEntry entry) {
        this.zoneId = zoneId;
        if (!(entry instanceof AttributeKvEntry)) {
            throw new IllegalArgumentException("Invalid perimeter data source for zone with id: " + String.valueOf(zoneId) + ". Perimeter definition must be stored as attribute!");
        }
        AttributeKvEntry attributeKvEntry = (AttributeKvEntry)entry;
        this.ts = attributeKvEntry.getLastUpdateTs();
        this.version = attributeKvEntry.getVersion();
        if (entry.getValueAsString() == null) {
            throw new IllegalArgumentException("Perimeter attribute '" + entry.getKey() + "' not found for Zone with id: " + String.valueOf(zoneId));
        }
        this.perimeterDefinition = (PerimeterDefinition)JacksonUtil.fromString((String)entry.getValueAsString(), PerimeterDefinition.class, (String)("Invalid perimeter definition format for Zone with id: " + String.valueOf(zoneId) + ". Failed to parse attribute '" + entry.getKey() + "'"));
    }

    public GeofencingZoneState(TransportProtos.GeofencingZoneProto proto) {
        this.zoneId = ProtoUtils.fromProto((TransportProtos.EntityIdProto)proto.getZoneId());
        this.ts = proto.getTs();
        this.version = proto.getVersion();
        this.perimeterDefinition = (PerimeterDefinition)JacksonUtil.fromString((String)proto.getPerimeterDefinition(), PerimeterDefinition.class);
        if (proto.hasInside()) {
            this.lastPresence = proto.getInside() ? GeofencingPresenceStatus.INSIDE : GeofencingPresenceStatus.OUTSIDE;
        }
    }

    public boolean update(GeofencingZoneState newZoneState) {
        if (newZoneState.getTs() <= this.ts) {
            return false;
        }
        Long newVersion = newZoneState.getVersion();
        if (newVersion == null || this.version == null || newVersion > this.version) {
            this.ts = newZoneState.getTs();
            this.version = newVersion;
            this.perimeterDefinition = newZoneState.getPerimeterDefinition();
            this.lastPresence = null;
            return true;
        }
        return false;
    }

    public GeofencingEvalResult evaluate(Coordinates entityCoordinates) {
        GeofencingPresenceStatus status;
        boolean nowInside = this.perimeterDefinition.checkMatches(entityCoordinates);
        GeofencingPresenceStatus geofencingPresenceStatus = status = nowInside ? GeofencingPresenceStatus.INSIDE : GeofencingPresenceStatus.OUTSIDE;
        if (this.lastPresence == null) {
            this.lastPresence = status;
            return new GeofencingEvalResult(null, status);
        }
        if (this.lastPresence != status) {
            this.lastPresence = status;
            GeofencingTransitionEvent transition = status == GeofencingPresenceStatus.INSIDE ? GeofencingTransitionEvent.ENTERED : GeofencingTransitionEvent.LEFT;
            return new GeofencingEvalResult(transition, status);
        }
        return new GeofencingEvalResult(null, status);
    }

    @Generated
    public EntityId getZoneId() {
        return this.zoneId;
    }

    @Generated
    public long getTs() {
        return this.ts;
    }

    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public PerimeterDefinition getPerimeterDefinition() {
        return this.perimeterDefinition;
    }

    @Generated
    public GeofencingPresenceStatus getLastPresence() {
        return this.lastPresence;
    }

    @Generated
    public void setTs(long ts) {
        this.ts = ts;
    }

    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Generated
    public void setPerimeterDefinition(PerimeterDefinition perimeterDefinition) {
        this.perimeterDefinition = perimeterDefinition;
    }

    @Generated
    public void setLastPresence(GeofencingPresenceStatus lastPresence) {
        this.lastPresence = lastPresence;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeofencingZoneState)) {
            return false;
        }
        GeofencingZoneState other = (GeofencingZoneState)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getTs() != other.getTs()) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        EntityId this$zoneId = this.getZoneId();
        EntityId other$zoneId = other.getZoneId();
        if (this$zoneId == null ? other$zoneId != null : !this$zoneId.equals(other$zoneId)) {
            return false;
        }
        PerimeterDefinition this$perimeterDefinition = this.getPerimeterDefinition();
        PerimeterDefinition other$perimeterDefinition = other.getPerimeterDefinition();
        return !(this$perimeterDefinition == null ? other$perimeterDefinition != null : !this$perimeterDefinition.equals(other$perimeterDefinition));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GeofencingZoneState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ts = this.getTs();
        result = result * 59 + (int)($ts >>> 32 ^ $ts);
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        EntityId $zoneId = this.getZoneId();
        result = result * 59 + ($zoneId == null ? 43 : $zoneId.hashCode());
        PerimeterDefinition $perimeterDefinition = this.getPerimeterDefinition();
        result = result * 59 + ($perimeterDefinition == null ? 43 : $perimeterDefinition.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GeofencingZoneState(zoneId=" + String.valueOf(this.getZoneId()) + ", ts=" + this.getTs() + ", version=" + this.getVersion() + ", perimeterDefinition=" + String.valueOf(this.getPerimeterDefinition()) + ", lastPresence=" + String.valueOf(this.getLastPresence()) + ")";
    }
}

